/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mdp.main;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.orpiske.mdp.plot.DefaultRateReader;
import net.orpiske.mdp.plot.FastRateReader;
import net.orpiske.mdp.plot.RateData;
import net.orpiske.mdp.plot.RateDataProcessor;
import net.orpiske.mdp.plot.RatePlotter;
import net.orpiske.mdp.plot.RatePropertyWriter;
import net.orpiske.mdp.plot.RateReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static CommandLine cmdLine;
    private static String fileName;
    private static boolean fast;

    private static void configureCommon(Properties properties) {
        properties.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.stdout.Target", "System.out");
        properties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%C.%M:%L [%p] %m%n");
        properties.setProperty("log4j.additivity.net.orpiske", "false");
    }

    private static void configureTrace(Properties properties) {
        properties.setProperty("log4j.rootLogger", "DEBUG, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "TRACE, stdout");
    }

    private static void configureDebug(Properties properties) {
        properties.setProperty("log4j.rootLogger", "INFO, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "DEBUG, stdout");
    }

    private static void configureVerbose(Properties properties) {
        properties.setProperty("log4j.rootLogger", "WARN, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "INFO, stdout");
    }

    private static void configureSilent(Properties properties) {
        properties.setProperty("log4j.rootLogger", "WARN, stdout");
        properties.setProperty("log4j.logger.net.orpiske", "WARN, stdout");
    }

    public static void trace() {
        Properties properties = new Properties();
        Main.configureCommon(properties);
        Main.configureTrace(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void debug() {
        Properties properties = new Properties();
        Main.configureCommon(properties);
        Main.configureDebug(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void verbose() {
        Properties properties = new Properties();
        Main.configureCommon(properties);
        Main.configureVerbose(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void silent() {
        Properties properties = new Properties();
        Main.configureCommon(properties);
        Main.configureSilent(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    private static void help(Options options, int code) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("mpt-data-plotter", options);
        System.exit(code);
    }

    private static void processCommand(String[] args) {
        String logLevel;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "prints the help");
        options.addOption("f", "file", true, "file to plot");
        options.addOption("l", "log-level", true, "optional log-level (one of trace, debug, info, silent [ default] )");
        options.addOption("F", "fast", false, "whether to use the fast reader or the default one)");
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            Main.help(options, -1);
        }
        if (cmdLine.hasOption("help")) {
            Main.help(options, 0);
        }
        if ((fileName = cmdLine.getOptionValue('f')) == null) {
            Main.help(options, -1);
        }
        if ((logLevel = cmdLine.getOptionValue('l')) == null) {
            logLevel = "silent";
        }
        switch (logLevel) {
            case "trace": {
                Main.trace();
                break;
            }
            case "debug": {
                Main.debug();
                break;
            }
            case "info": {
                Main.verbose();
                break;
            }
            default: {
                Main.silent();
            }
        }
        fast = cmdLine.hasOption('F');
    }

    public static void main(String[] args) {
        Main.processCommand(args);
        try {
            RateDataProcessor rateDataProcessor = new RateDataProcessor();
            RateReader rateReader = fast ? new FastRateReader(rateDataProcessor) : new DefaultRateReader(rateDataProcessor);
            rateReader.read(fileName);
            logger.info("Reading the rate records file");
            RateData rateData = rateDataProcessor.getRateData();
            String baseName = FilenameUtils.removeExtension(fileName);
            baseName = FilenameUtils.removeExtension(baseName);
            RatePlotter plotter = new RatePlotter(baseName);
            List<Date> ratePeriods = rateData.getRatePeriods();
            logger.info("Number of rate records to plot: {}", (Object)ratePeriods.size());
            logger.info("Number of rate records in error: {}", (Object)rateData.getErrorCount());
            if (logger.isDebugEnabled()) {
                for (Date d : ratePeriods) {
                    logger.debug("Adding date record for plotting: {}", (Object)d);
                }
            }
            logger.info("Plotting the records");
            plotter.plot(ratePeriods, rateData.getRateValues());
            logger.info("Writing the properties file");
            File input = new File(fileName);
            RatePropertyWriter.write(rateData, input.getParentFile());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        System.exit(1);
    }
}

