/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.writers;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;

public final class OneToOneWorkerChannel {
    private final BroadcastTransmitter writeBuffer;
    private final BroadcastReceiver receiver;
    private final UnsafeBuffer sampleBuffer;
    private final Sample currentSample;
    private final int footprintInBytes;

    public OneToOneWorkerChannel(int capacity) {
        capacity = Math.max(8, capacity);
        int contentLength = 16;
        this.sampleBuffer = new UnsafeBuffer(ByteBuffer.allocateDirect(16));
        int requiredRingBufferCapacity = BitUtil.findNextPositivePowerOfTwo((int)(BitUtil.findNextPositivePowerOfTwo((int)capacity) * BitUtil.align((int)24, (int)8))) + BroadcastBufferDescriptor.TRAILER_LENGTH;
        UnsafeBuffer buffer = new UnsafeBuffer(ByteBuffer.allocateDirect(requiredRingBufferCapacity));
        this.writeBuffer = new BroadcastTransmitter((AtomicBuffer)buffer);
        this.currentSample = new Sample();
        this.receiver = new BroadcastReceiver((AtomicBuffer)buffer);
        this.footprintInBytes = buffer.capacity();
        this.currentSample.buffer = (DirectBuffer)this.sampleBuffer;
        this.currentSample.offset = 0;
    }

    public void emitRate(long startTimestampEpochMicros, long endTimestampEpochMicros) {
        assert (startTimestampEpochMicros - endTimestampEpochMicros <= 0L) : "startTimestampEpochMicros <= endTimestampEpochMicros";
        this.sampleBuffer.putLong(0, startTimestampEpochMicros);
        this.sampleBuffer.putLong(8, endTimestampEpochMicros);
        this.writeBuffer.transmit(1, (DirectBuffer)this.sampleBuffer, 0, this.sampleBuffer.capacity());
    }

    public int footprintInBytes() {
        return this.footprintInBytes;
    }

    public int readRate(Consumer<Sample> onRate, int limit) {
        for (int i = 0; i < limit; ++i) {
            boolean valid;
            do {
                boolean receiveNext;
                if (!(receiveNext = this.receiver.receiveNext())) {
                    return i;
                }
                this.sampleBuffer.putBytes(0, (DirectBuffer)this.receiver.buffer(), this.receiver.offset(), this.receiver.length());
            } while (!(valid = this.receiver.validate()));
            onRate.accept(this.currentSample);
        }
        return limit;
    }

    public long missedSamples() {
        return this.receiver.lappedCount();
    }

    public static final class Sample {
        private DirectBuffer buffer;
        private int offset;

        public long timestampEpochMicros() {
            return this.buffer.getLong(this.offset);
        }

        public long value() {
            return this.buffer.getLong(this.offset + 8);
        }
    }
}

