/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.HistogramLogWriter;

public final class LatencyWriter
implements AutoCloseable {
    private final HistogramLogWriter logWriter;
    private final OutputStream out;

    public LatencyWriter(File path) throws IOException {
        this.out = new FileOutputStream(path);
        this.logWriter = new HistogramLogWriter(this.out);
    }

    public void outputLegend(long startedEpochMillis) {
        this.logWriter.outputComment("[mpt]");
        this.logWriter.outputLogFormatVersion();
        this.logWriter.outputStartTime(startedEpochMillis);
        this.logWriter.outputLegend();
    }

    public void outputIntervalHistogram(EncodableHistogram histogram) {
        this.logWriter.outputIntervalHistogram(histogram);
    }

    @Override
    public void close() {
        try {
            this.out.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.logWriter.close();
        }
    }
}

