/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.duration;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.concurrent.TimeUnit;
import net.orpiske.mpt.common.duration.EpochMicroClock;
import net.orpiske.mpt.common.duration.timespec;

public final class JnaStructNativeClock
implements EpochMicroClock {
    private final timespec ts = new timespec.ByReference();

    public static native void clock_gettime(int var0, timespec var1);

    public long currentTimeNanos() {
        JnaStructNativeClock.clock_gettime(0, this.ts);
        long tv_sec = this.ts.tv_sec;
        long tv_ns = this.ts.tv_nsec;
        return TimeUnit.SECONDS.toNanos(tv_sec) + tv_ns;
    }

    public long currentTimeMicros() {
        JnaStructNativeClock.clock_gettime(0, this.ts);
        long tv_sec = this.ts.tv_sec;
        long tv_ns = this.ts.tv_nsec;
        return TimeUnit.SECONDS.toMicros(tv_sec) + tv_ns / 1000L;
    }

    @Override
    public long microTime() {
        return this.currentTimeMicros();
    }

    static {
        Native.register(Platform.C_LIBRARY_NAME);
    }
}

