/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.duration;

import java.time.Duration;
import net.orpiske.mpt.common.exceptions.DurationParseException;

public class DurationUtils {
    private DurationUtils() {
    }

    public static long parse(CharSequence sequence) throws DurationParseException {
        Duration d = Duration.ZERO;
        int last = 0;
        block6: for (int i = 0; i < sequence.length(); ++i) {
            switch (sequence.charAt(i)) {
                case 's': {
                    CharSequence tmp = sequence.subSequence(last, i);
                    if (tmp == null) {
                        throw new DurationParseException("Unable to parse the sequence " + sequence);
                    }
                    int number = Integer.parseInt(tmp.toString());
                    Duration tmpSeconds = Duration.ofSeconds(number);
                    d = d.plus(tmpSeconds);
                    last = i + 1;
                    continue block6;
                }
                case 'm': {
                    CharSequence tmp = sequence.subSequence(last, i);
                    if (tmp == null) {
                        throw new DurationParseException("Unable to parse the sequence " + sequence);
                    }
                    int number = Integer.parseInt(tmp.toString());
                    d = d.plusMinutes(number);
                    last = i + 1;
                    continue block6;
                }
                case 'h': {
                    CharSequence tmp = sequence.subSequence(last, i);
                    if (tmp == null) {
                        throw new DurationParseException("Unable to parse the sequence " + sequence);
                    }
                    int number = Integer.parseInt(tmp.toString());
                    d = d.plusHours(number);
                    last = i + 1;
                    continue block6;
                }
                case 'd': {
                    CharSequence tmp = sequence.subSequence(last, i);
                    if (tmp == null) {
                        throw new DurationParseException("Unable to parse the sequence " + sequence);
                    }
                    int number = Integer.parseInt(tmp.toString());
                    d = d.plusDays(number);
                    last = i + 1;
                    continue block6;
                }
                default: {
                    if (last != 0 || i != sequence.length() - 1) continue block6;
                    int number = Integer.parseInt(sequence.toString());
                    d = d.plusSeconds(number);
                    last = i + 1;
                }
            }
        }
        return d.getSeconds();
    }
}

