/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.common.duration;

import java.util.concurrent.TimeUnit;
import net.orpiske.mpt.common.duration.DurationUtils;
import net.orpiske.mpt.common.duration.TestDuration;
import net.orpiske.mpt.common.exceptions.DurationParseException;

public class DurationTime
implements TestDuration {
    private static final String DURATION_TYPE_NAME = "time";
    private final long expectedDuration;
    private final TimeUnit outputTimeUnit;
    private final String timeSpec;

    public DurationTime(String timeSpec) throws DurationParseException {
        this.expectedDuration = DurationUtils.parse(timeSpec);
        this.timeSpec = timeSpec;
        this.outputTimeUnit = TimeUnit.SECONDS;
    }

    @Override
    public boolean canContinue(TestDuration.TestProgress snapshot) {
        long currentDuration = snapshot.elapsedTime(this.outputTimeUnit);
        return currentDuration < this.expectedDuration;
    }

    @Override
    public long getNumericDuration() {
        return this.expectedDuration;
    }

    public String toString() {
        return this.timeSpec;
    }

    @Override
    public String durationTypeName() {
        return DURATION_TYPE_NAME;
    }
}

