/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.series;

import java.awt.BasicStroke;
import java.awt.Color;
import org.knowm.xchart.internal.series.Series;

public abstract class AxesChartSeries
extends Series {
    final Series.DataType xAxisDataType;
    final Series.DataType yAxisType;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    private BasicStroke stroke;
    private Color lineColor;
    private float lineWidth = -1.0f;

    protected abstract void calculateMinMax();

    AxesChartSeries(String name, Series.DataType xAxisDataType) {
        super(name);
        this.xAxisDataType = xAxisDataType;
        this.yAxisType = Series.DataType.Number;
    }

    public AxesChartSeries setLineStyle(BasicStroke basicStroke) {
        this.stroke = basicStroke;
        if (this.lineWidth > 0.0f) {
            this.stroke = new BasicStroke(this.lineWidth, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        }
        return this;
    }

    public AxesChartSeries setLineColor(Color color) {
        this.lineColor = color;
        return this;
    }

    public AxesChartSeries setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public BasicStroke getLineStyle() {
        return this.stroke;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public Series.DataType getxAxisDataType() {
        return this.xAxisDataType;
    }

    public Series.DataType getyAxisDataType() {
        return this.yAxisType;
    }
}

