/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.knowm.xchart.RadarChart;
import org.knowm.xchart.RadarSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.RadarStyler;
import org.knowm.xchart.style.Styler;

public class PlotContent_Radar<ST extends Styler, S extends Series>
extends PlotContent_ {
    private static final int MARGIN = 5;
    private final RadarStyler styler;
    private final NumberFormat df = DecimalFormat.getPercentInstance();
    double radarX;
    double radarY;
    double xCenter;
    double yCenter;
    double xDiameter;
    double yDiameter;

    PlotContent_Radar(Chart<RadarStyler, RadarSeries> chart) {
        super(chart);
        this.styler = chart.getStyler();
    }

    protected void calculatePlotVaraiables(double widthCorrection, double heightCorrection) {
        double height;
        double width;
        double fillPercentage = this.styler.getPlotContentSize();
        double boundsWidth = this.getBounds().getWidth();
        double boundsHeight = this.getBounds().getHeight();
        double halfBorderPercentage = (1.0 - fillPercentage) / 2.0;
        if (this.styler.isCircular()) {
            height = width = Math.min(boundsWidth, boundsHeight);
        } else {
            width = boundsWidth;
            height = boundsHeight;
        }
        this.radarX = this.getBounds().getX() + boundsWidth / 2.0 - width / 2.0 + halfBorderPercentage * width;
        this.radarY = this.getBounds().getY() + boundsHeight / 2.0 - height / 2.0 + halfBorderPercentage * height;
        double radarW = width * fillPercentage;
        double radarH = height * fillPercentage;
        this.xDiameter = (radarW - widthCorrection) / 2.0;
        this.yDiameter = (radarH - heightCorrection) / 2.0;
        this.xCenter = this.radarX + radarW / 2.0;
        this.yCenter = this.radarY + radarH / 2.0;
    }

    @Override
    public void doPaint(Graphics2D g) {
        int i;
        this.calculatePlotVaraiables(0.0, 0.0);
        String[] variableLabels = ((RadarChart)this.chart).getVariableLabels();
        int variableCount = variableLabels.length;
        Map map = this.chart.getSeriesMap();
        RadarChart radarChart = (RadarChart)this.chart;
        double angleForSeries = 360.0 / (double)variableCount;
        double[] cosArr = new double[variableCount];
        double[] sinArr = new double[variableCount];
        Shape[] labelShapes = null;
        double[] labelX = null;
        double[] labelY = null;
        boolean axisTitleVisible = this.styler.isAxisTitleVisible();
        if (axisTitleVisible) {
            labelShapes = new Shape[variableCount];
            labelX = new double[variableCount];
            labelY = new double[variableCount];
        }
        double startAngle = this.styler.getStartAngleInDegrees() + 90.0;
        for (i = 0; i < variableCount; ++i) {
            double radians = Math.toRadians(startAngle);
            double cos = Math.cos(radians);
            double sin = Math.sin(radians);
            cosArr[i] = cos;
            sinArr[i] = sin;
            if (axisTitleVisible) {
                Shape shape;
                String annotation = variableLabels[i];
                TextLayout textLayout = new TextLayout(annotation, this.styler.getAxisTitleFont(), new FontRenderContext(null, true, false));
                labelShapes[i] = shape = textLayout.getOutline(null);
            }
            startAngle += angleForSeries;
        }
        if (axisTitleVisible) {
            Rectangle clipBounds = g.getClipBounds();
            double leftEdge = clipBounds.getX() + 5.0;
            double rightEdge = clipBounds.getMaxX() - 10.0;
            double topEdge = clipBounds.getY() + 5.0;
            double bottomEdge = clipBounds.getMaxY() - 10.0;
            startAngle = this.styler.getStartAngleInDegrees() + 90.0;
            int tryCount = 0;
            int axisTitlePadding = this.styler.getAxisTitlePadding();
            for (int i2 = 0; i2 < variableCount; ++i2) {
                double cos = cosArr[i2];
                double sin = sinArr[i2];
                Shape shape = labelShapes[i2];
                Rectangle2D annotationBounds = shape.getBounds2D();
                double annotationWidth = annotationBounds.getWidth();
                double annotationHeight = annotationBounds.getHeight();
                double xOffset = this.xCenter - annotationWidth / 2.0 + cos * (this.xDiameter + (double)axisTitlePadding);
                double yOffset = this.yCenter + annotationHeight / 2.0 - sin * (this.yDiameter + (double)axisTitlePadding);
                double tx = xOffset - Math.sin(Math.toRadians(startAngle - 90.0)) * (annotationWidth / 2.0 + (double)axisTitlePadding);
                double ty = Math.abs(startAngle - 90.0) <= 15.0 || Math.abs(startAngle - 270.0) <= 15.0 ? yOffset : yOffset + Math.cos(Math.toRadians(startAngle - 90.0)) * annotationHeight;
                double x = tx;
                double y = ty;
                x = Math.max(x, leftEdge);
                x = Math.min(x, rightEdge - annotationWidth);
                y = Math.max(y, topEdge);
                y = Math.min(y, bottomEdge - annotationHeight);
                double wcorr = Math.abs(x - tx);
                double hcorr = Math.abs(y - ty);
                if ((wcorr > 0.0 || hcorr > 0.0) && tryCount < variableCount) {
                    if (wcorr > 0.0) {
                        this.xDiameter -= Math.abs(wcorr / cos);
                    }
                    if (hcorr > 0.0) {
                        this.yDiameter -= Math.abs(hcorr / sin);
                    }
                    if (this.styler.isCircular()) {
                        this.yDiameter = this.xDiameter = Math.min(this.xDiameter, this.yDiameter);
                    }
                    ++tryCount;
                    i2 = -1;
                    startAngle = this.styler.getStartAngleInDegrees() + 90.0;
                    continue;
                }
                labelX[i2] = x;
                labelY[i2] = y;
                startAngle += angleForSeries;
            }
        }
        startAngle = this.styler.getStartAngleInDegrees() + 90.0;
        for (i = 0; i < variableCount; ++i) {
            double cos = cosArr[i];
            double sin = sinArr[i];
            if (this.styler.isPlotGridLinesVisible()) {
                double xOffset = this.xCenter + cos * this.xDiameter;
                double yOffset = this.yCenter - sin * this.yDiameter;
                Line2D.Double line = new Line2D.Double(this.xCenter, this.yCenter, xOffset, yOffset);
                g.setColor(this.styler.getPlotGridLinesColor());
                g.setStroke(this.styler.getPlotGridLinesStroke());
                g.draw(line);
            }
            if (axisTitleVisible) {
                g.setColor(this.styler.getChartFontColor());
                g.setFont(this.styler.getAnnotationsFont());
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(labelX[i], labelY[i]);
                Shape shape = labelShapes[i];
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
            startAngle += angleForSeries;
        }
        int markCount = this.styler.getAxisTickMarksCount();
        if (markCount > 0 && this.styler.isAxisTicksMarksVisible()) {
            g.setColor(this.styler.getAxisTickMarksColor());
            g.setStroke(this.styler.getAxisTickMarksStroke());
            if (radarChart.getRadarRenderStyle() == RadarChart.RadarRenderStyle.Circle) {
                Ellipse2D.Double markShape = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);
                double winc = this.xDiameter / (double)markCount;
                double hinc = this.yDiameter / (double)markCount;
                double newXd = this.xDiameter;
                double newYd = this.yDiameter;
                for (int i3 = 0; i3 < markCount; ++i3) {
                    markShape.width = newXd * 2.0;
                    markShape.height = newYd * 2.0;
                    markShape.x = this.xCenter - newXd;
                    markShape.y = this.yCenter - newYd;
                    g.draw(markShape);
                    newXd -= winc;
                    newYd -= hinc;
                }
            }
            if (radarChart.getRadarRenderStyle() == RadarChart.RadarRenderStyle.Polygon) {
                double winc = this.xDiameter / (double)markCount;
                double hinc = this.yDiameter / (double)markCount;
                for (int markerInd = 0; markerInd < markCount; ++markerInd) {
                    Path2D.Double path = new Path2D.Double();
                    for (int varInd = 0; varInd < variableCount; ++varInd) {
                        double cos = cosArr[varInd];
                        double sin = sinArr[varInd];
                        double xOffset = this.xCenter + cos * (this.xDiameter - (double)markerInd * winc);
                        double yOffset = this.yCenter - sin * (this.yDiameter - (double)markerInd * hinc);
                        if (varInd == 0) {
                            path.moveTo(xOffset, yOffset);
                            continue;
                        }
                        path.lineTo(xOffset, yOffset);
                    }
                    path.closePath();
                    g.draw(path);
                }
            }
        }
        Path2D.Double[] paths = new Path2D.Double[variableCount];
        for (int i4 = 0; i4 < paths.length; ++i4) {
            paths[i4] = new Path2D.Double();
        }
        NumberFormat decimalFormat = this.styler.getDecimalPattern() == null ? this.df : new DecimalFormat(this.styler.getDecimalPattern());
        for (RadarSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            double[] values = series.getValues();
            String[] toolTips = series.getTooltipOverrides();
            g.setColor(series.getFillColor());
            Path2D.Double path = new Path2D.Double();
            for (int varInd = 0; varInd < variableCount; ++varInd) {
                double cos = cosArr[varInd];
                double sin = sinArr[varInd];
                double perct = values[varInd];
                double xOffset = this.xCenter + cos * (this.xDiameter * perct);
                double yOffset = this.yCenter - sin * (this.yDiameter * perct);
                if (varInd == 0) {
                    path.moveTo(xOffset, yOffset);
                } else {
                    path.lineTo(xOffset, yOffset);
                }
                if (series.getMarker() != null) {
                    g.setColor(series.getMarkerColor());
                    series.getMarker().paint(g, xOffset, yOffset, this.styler.getMarkerSize());
                }
                if (!((Styler)this.chart.getStyler()).isToolTipsEnabled()) continue;
                String label = null;
                if (toolTips != null) {
                    label = toolTips[varInd];
                }
                if (label == null) {
                    String ystr = decimalFormat.format(perct);
                    label = series.getName() + " (" + variableLabels[varInd] + ": " + ystr + ")";
                }
                this.chart.toolTips.addData(xOffset, yOffset, label);
            }
            path.closePath();
            g.setColor(series.getLineColor());
            g.draw(path);
            g.setColor(series.getFillColor());
            g.fill(path);
        }
    }
}

