/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.lines.SeriesLines;

public class PlotContent_Category_Bar<ST extends Styler, S extends Series>
extends PlotContent_ {
    private final CategoryStyler stylerCategory;

    PlotContent_Category_Bar(Chart<CategoryStyler, CategorySeries> chart) {
        super(chart);
        this.stylerCategory = chart.getStyler();
    }

    private static void drawStepBarLine(Graphics2D g, CategorySeries series, Path2D.Double path) {
        if (series.getLineColor() != null) {
            g.setColor(series.getLineColor());
            g.setStroke(series.getLineStyle());
            g.draw(path);
        }
    }

    private static void drawStepBarFill(Graphics2D g, CategorySeries series, Path2D.Double path) {
        if (series.getFillColor() != null) {
            g.setColor(series.getFillColor());
            g.fill(path);
        }
    }

    private static void drawStepBar(Graphics2D g, CategorySeries series, ArrayList<Point2D.Double> path, ArrayList<Point2D.Double> returnPath) {
        Collections.reverse(returnPath);
        returnPath.remove(returnPath.size() - 1);
        path.addAll(returnPath);
        Path2D.Double drawPath = new Path2D.Double();
        Point2D.Double startPoint = path.remove(0);
        drawPath.moveTo(startPoint.getX(), startPoint.getY());
        for (Point2D.Double currentPoint : path) {
            drawPath.lineTo(currentPoint.getX(), currentPoint.getY());
        }
        PlotContent_Category_Bar.drawStepBarFill(g, series, drawPath);
        drawPath.reset();
        drawPath.moveTo(startPoint.getX(), startPoint.getY());
        List<Point2D.Double> linePath = path.subList(0, path.size() - returnPath.size() + 1);
        for (Point2D.Double currentPoint : linePath) {
            drawPath.lineTo(currentPoint.getX(), currentPoint.getY());
        }
        PlotContent_Category_Bar.drawStepBarLine(g, series, drawPath);
    }

    @Override
    public void doPaint(Graphics2D g) {
        double xTickSpace = this.stylerCategory.getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset(this.getBounds().getWidth(), xTickSpace);
        Map seriesMap = this.chart.getSeriesMap();
        int numCategories = ((CategorySeries)seriesMap.values().iterator().next()).getXData().size();
        double gridStep = xTickSpace / (double)numCategories;
        double yMin = this.chart.getYAxis().getMin();
        double yMax = this.chart.getYAxis().getMax();
        int chartForm = 1;
        chartForm = yMin > 0.0 && yMax > 0.0 ? 1 : (yMin < 0.0 && yMax < 0.0 ? -1 : 0);
        double yTickSpace = this.stylerCategory.getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset(this.getBounds().getHeight(), yTickSpace);
        int seriesCounter = 0;
        double[] accumulatedStackOffsetPos = new double[numCategories];
        double[] accumulatedStackOffsetNeg = new double[numCategories];
        for (CategorySeries series : seriesMap.values()) {
            if (!series.isEnabled()) continue;
            yMin = this.chart.getYAxis(series.getYAxisGroup()).getMin();
            yMax = this.chart.getYAxis(series.getYAxisGroup()).getMax();
            double previousX = -1.7976931348623157E308;
            double previousY = -1.7976931348623157E308;
            Iterator<?> xItr = series.getXData().iterator();
            Iterator<? extends Number> yItr = series.getYData().iterator();
            Iterator<? extends Number> ebItr = null;
            Collection<? extends Number> errorBars = series.getExtraValues();
            if (errorBars != null) {
                ebItr = errorBars.iterator();
            }
            ArrayList<Point2D.Double> steppedPath = null;
            ArrayList<Point2D.Double> steppedReturnPath = null;
            int categoryCounter = 0;
            block6: while (yItr.hasNext()) {
                double xOffset;
                double barMargin;
                double barWidth;
                Number next = yItr.next();
                if (next == null) {
                    previousX = -1.7976931348623157E308;
                    previousY = -1.7976931348623157E308;
                    ++categoryCounter;
                    continue;
                }
                Object nextCat = xItr.next();
                double y = next.doubleValue();
                double yTop = 0.0;
                double yBottom = 0.0;
                switch (chartForm) {
                    case 1: {
                        if (y < yMin) {
                            ++categoryCounter;
                            continue block6;
                        }
                        yTop = y;
                        yBottom = yMin;
                        if (!this.stylerCategory.isStacked()) break;
                        int n = categoryCounter;
                        accumulatedStackOffsetPos[n] = accumulatedStackOffsetPos[n] + ((yTop += accumulatedStackOffsetPos[categoryCounter]) - (yBottom += accumulatedStackOffsetPos[categoryCounter]));
                        break;
                    }
                    case -1: {
                        if (y > yMax) {
                            ++categoryCounter;
                            continue block6;
                        }
                        yTop = yMax;
                        yBottom = y;
                        if (!this.stylerCategory.isStacked()) break;
                        int n = categoryCounter;
                        accumulatedStackOffsetNeg[n] = accumulatedStackOffsetNeg[n] + ((yTop -= accumulatedStackOffsetNeg[categoryCounter]) - (yBottom -= accumulatedStackOffsetNeg[categoryCounter]));
                        break;
                    }
                    case 0: {
                        if (y >= 0.0) {
                            yTop = y;
                            yBottom = series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Bar || series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Stick || series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.SteppedBar ? 0.0 : y;
                            if (!this.stylerCategory.isStacked()) break;
                            int n = categoryCounter;
                            accumulatedStackOffsetPos[n] = accumulatedStackOffsetPos[n] + ((yTop += accumulatedStackOffsetPos[categoryCounter]) - (yBottom += accumulatedStackOffsetPos[categoryCounter]));
                            break;
                        }
                        yTop = series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Bar || series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Stick || series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.SteppedBar ? 0.0 : y;
                        yBottom = y;
                        if (!this.stylerCategory.isStacked()) break;
                        int n = categoryCounter;
                        accumulatedStackOffsetNeg[n] = accumulatedStackOffsetNeg[n] + ((yTop -= accumulatedStackOffsetNeg[categoryCounter]) - (yBottom -= accumulatedStackOffsetNeg[categoryCounter]));
                        break;
                    }
                }
                double yTransform = this.getBounds().getHeight() - (yTopMargin + (yTop - yMin) / (yMax - yMin) * yTickSpace);
                double yOffset = this.getBounds().getY() + yTransform;
                double zeroTransform = this.getBounds().getHeight() - (yTopMargin + (yBottom - yMin) / (yMax - yMin) * yTickSpace);
                double zeroOffset = this.getBounds().getY() + zeroTransform;
                double barWidthPercentage = this.stylerCategory.getAvailableSpaceFill();
                if (series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.SteppedBar) {
                    barWidthPercentage = 1.0;
                }
                if (this.stylerCategory.isOverlapped() || this.stylerCategory.isStacked()) {
                    barWidth = gridStep * barWidthPercentage;
                    barMargin = gridStep * (1.0 - barWidthPercentage) / 2.0;
                    xOffset = this.getBounds().getX() + xLeftMargin + gridStep * (double)categoryCounter++ + barMargin;
                } else {
                    barWidth = gridStep / (double)this.chart.getSeriesMap().size() * barWidthPercentage;
                    barMargin = gridStep * (1.0 - barWidthPercentage) / 2.0;
                    xOffset = this.getBounds().getX() + xLeftMargin + gridStep * (double)categoryCounter++ + (double)seriesCounter * barWidth + barMargin;
                }
                if (series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.SteppedBar) {
                    double yCenter = zeroOffset;
                    double yTip = yOffset;
                    double stepLength = gridStep;
                    if (y < 0.0) {
                        yTip = zeroOffset;
                        yCenter = yOffset;
                    }
                    if (steppedPath == null) {
                        steppedPath = new ArrayList<Point2D.Double>();
                        steppedReturnPath = new ArrayList<Point2D.Double>();
                        steppedPath.add(new Point2D.Double(xOffset, yCenter));
                    } else if (this.stylerCategory.isStacked() && (previousY > 0.0 && y < 0.0 || previousY < 0.0 && y > 0.0)) {
                        PlotContent_Category_Bar.drawStepBar(g, series, steppedPath, steppedReturnPath);
                        steppedPath.clear();
                        steppedReturnPath.clear();
                        steppedPath.add(new Point2D.Double(xOffset, yCenter));
                    }
                    if (!(yItr.hasNext() || this.stylerCategory.isOverlapped() || this.stylerCategory.isStacked())) {
                        double singleBarStep = stepLength / (double)this.chart.getSeriesMap().size();
                        stepLength -= (double)seriesCounter * singleBarStep;
                    }
                    steppedPath.add(new Point2D.Double(xOffset, yTip));
                    steppedPath.add(new Point2D.Double(xOffset + stepLength, yTip));
                    steppedReturnPath.add(new Point2D.Double(xOffset, yCenter));
                    steppedReturnPath.add(new Point2D.Double(xOffset + stepLength, yCenter));
                    previousY = y;
                } else if (series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Bar) {
                    Path2D.Double path = new Path2D.Double();
                    path.moveTo(xOffset, yOffset);
                    path.lineTo(xOffset + barWidth, yOffset);
                    path.lineTo(xOffset + barWidth, zeroOffset);
                    path.lineTo(xOffset, zeroOffset);
                    path.closePath();
                    g.setColor(series.getFillColor());
                    g.fill(path);
                    if (this.stylerCategory.hasAnnotations().booleanValue() && next != null) {
                        String numberAsString = this.chart.getYAxisFormat().format(next);
                        TextLayout textLayout = new TextLayout(numberAsString, this.stylerCategory.getAnnotationsFont(), new FontRenderContext(null, true, false));
                        Rectangle2D annotationRectangle = textLayout.getBounds();
                        double annotationX = xOffset + barWidth / 2.0 - annotationRectangle.getWidth() / 2.0;
                        double annotationY = next.doubleValue() >= 0.0 ? yOffset - 4.0 : zeroOffset + 4.0 + annotationRectangle.getHeight();
                        Shape shape = textLayout.getOutline(null);
                        g.setColor(this.stylerCategory.getChartFontColor());
                        g.setFont(this.stylerCategory.getAnnotationsFont());
                        AffineTransform orig = g.getTransform();
                        AffineTransform at = new AffineTransform();
                        at.translate(annotationX, annotationY);
                        g.transform(at);
                        g.fill(shape);
                        g.setTransform(orig);
                    }
                } else if (CategorySeries.CategorySeriesRenderStyle.Stick.equals(series.getChartCategorySeriesRenderStyle())) {
                    if (series.getLineStyle() != SeriesLines.NONE) {
                        g.setColor(series.getLineColor());
                        g.setStroke(series.getLineStyle());
                        Line2D.Double line = new Line2D.Double(xOffset + barWidth / 2.0, zeroOffset, xOffset + barWidth / 2.0, yOffset);
                        g.draw(line);
                    }
                    if (series.getMarker() != null) {
                        g.setColor(series.getMarkerColor());
                        if (y <= 0.0) {
                            series.getMarker().paint(g, xOffset + barWidth / 2.0, zeroOffset, this.stylerCategory.getMarkerSize());
                        } else {
                            series.getMarker().paint(g, xOffset + barWidth / 2.0, yOffset, this.stylerCategory.getMarkerSize());
                        }
                    }
                } else {
                    if (series.getChartCategorySeriesRenderStyle() == CategorySeries.CategorySeriesRenderStyle.Line && series.getLineStyle() != SeriesLines.NONE && previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                        g.setColor(series.getLineColor());
                        g.setStroke(series.getLineStyle());
                        Line2D.Double line = new Line2D.Double(previousX, previousY, xOffset + barWidth / 2.0, yOffset);
                        g.draw(line);
                    }
                    previousX = xOffset + barWidth / 2.0;
                    previousY = yOffset;
                    if (series.getMarker() != null) {
                        g.setColor(series.getMarkerColor());
                        series.getMarker().paint(g, previousX, previousY, this.stylerCategory.getMarkerSize());
                    }
                }
                if (errorBars != null) {
                    double eb = ebItr.next().doubleValue();
                    if (this.stylerCategory.isErrorBarsColorSeriesColor()) {
                        g.setColor(series.getLineColor());
                    } else {
                        g.setColor(this.stylerCategory.getErrorBarsColor());
                    }
                    g.setStroke(this.errorBarStroke);
                    double errorBarLength = eb / (yMax - yMin) * yTickSpace;
                    double topEBOffset = yOffset - errorBarLength;
                    double bottomEBOffset = yOffset + errorBarLength;
                    double errorBarOffset = xOffset + barWidth / 2.0;
                    Line2D.Double line = new Line2D.Double(errorBarOffset, topEBOffset, errorBarOffset, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(errorBarOffset - 3.0, bottomEBOffset, errorBarOffset + 3.0, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(errorBarOffset - 3.0, topEBOffset, errorBarOffset + 3.0, topEBOffset);
                    g.draw(line);
                }
                if (this.chart.toolTips == null) continue;
                Rectangle2D.Double rect = new Rectangle2D.Double(xOffset, yOffset, barWidth, Math.abs(yOffset - zeroOffset));
                double yPoint = y < 0.0 ? zeroOffset + 4.0 + 20.0 + 5.0 : yOffset;
                this.chart.toolTips.addData(rect, xOffset, yPoint, barWidth, this.chart.getXAxisFormat().format(nextCat), this.chart.getYAxisFormat().format(y));
            }
            if (steppedPath != null && !steppedReturnPath.isEmpty()) {
                PlotContent_Category_Bar.drawStepBar(g, series, steppedPath, steppedReturnPath);
            }
            ++seriesCounter;
        }
    }
}

