/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.CSVExporter;
import org.knowm.xchart.VectorGraphicsEncoder;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ToolTips;

public class XChartPanel<T extends Chart>
extends JPanel {
    private final T chart;
    private final Dimension preferredSize;
    private String saveAsString = "Save As...";
    private String exportAsString = "Export To...";

    public XChartPanel(T chart) {
        MouseMotionListener mml;
        this.chart = chart;
        this.preferredSize = new Dimension(((Chart)chart).getWidth(), ((Chart)chart).getHeight());
        this.addMouseListener(new PopUpMenuClickListener());
        ToolTips toolTips = ((Chart)chart).getToolTips();
        if (toolTips != null && (mml = toolTips.getMouseMotionListener()) != null) {
            this.addMouseMotionListener(mml);
        }
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(ctrlS, "save");
        this.getActionMap().put("save", new SaveAction());
        KeyStroke ctrlE = KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(ctrlE, "export");
        this.getActionMap().put("export", new ExportAction());
    }

    public void setSaveAsString(String saveAsString) {
        this.saveAsString = saveAsString;
    }

    public void setExportAsString(String exportAsString) {
        this.exportAsString = exportAsString;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        ((Chart)this.chart).paint(g2d, this.getWidth(), this.getHeight());
        g2d.dispose();
    }

    public T getChart() {
        return this.chart;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private void showSaveAsDialog() {
        UIManager.put("FileChooser.saveButtonText", "Save");
        UIManager.put("FileChooser.fileNameLabelText", "File Name:");
        JFileChooser fileChooser = new JFileChooser();
        SuffixSaveFilter pngFileFilter = new SuffixSaveFilter("png");
        fileChooser.addChoosableFileFilter(pngFileFilter);
        fileChooser.addChoosableFileFilter(new SuffixSaveFilter("jpg"));
        fileChooser.addChoosableFileFilter(new SuffixSaveFilter("bmp"));
        fileChooser.addChoosableFileFilter(new SuffixSaveFilter("gif"));
        try {
            Class.forName("de.erichseifert.vectorgraphics2d.VectorGraphics2D");
            fileChooser.addChoosableFileFilter(new SuffixSaveFilter("svg"));
            fileChooser.addChoosableFileFilter(new SuffixSaveFilter("eps"));
            fileChooser.addChoosableFileFilter(new SuffixSaveFilter("pdf"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(pngFileFilter);
        if (fileChooser.showSaveDialog(null) == 0 && fileChooser.getSelectedFile() != null) {
            File theFileToSave = fileChooser.getSelectedFile();
            try {
                if (fileChooser.getFileFilter() == null) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.PNG);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.jpg,*.JPG")) {
                    BitmapEncoder.saveJPGWithQuality(this.chart, BitmapEncoder.addFileExtension(theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.JPG), 1.0f);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.png,*.PNG")) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.PNG);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.bmp,*.BMP")) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.BMP);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.gif,*.GIF")) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.GIF);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.svg,*.SVG")) {
                    VectorGraphicsEncoder.saveVectorGraphic(this.chart, theFileToSave.getCanonicalPath(), VectorGraphicsEncoder.VectorGraphicsFormat.SVG);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.eps,*.EPS")) {
                    VectorGraphicsEncoder.saveVectorGraphic(this.chart, theFileToSave.getCanonicalPath(), VectorGraphicsEncoder.VectorGraphicsFormat.EPS);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.pdf,*.PDF")) {
                    VectorGraphicsEncoder.saveVectorGraphic(this.chart, theFileToSave.getCanonicalPath(), VectorGraphicsEncoder.VectorGraphicsFormat.PDF);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showExportAsDialog() {
        UIManager.put("FileChooser.saveButtonText", "Export");
        UIManager.put("FileChooser.fileNameLabelText", "Export To:");
        UIManager.put("FileChooser.saveDialogFileNameLabel.textAndMnemonic", "Export To:");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Any Directory";
            }
        });
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle("Export");
        if (fileChooser.showSaveDialog(null) == 0) {
            File theFileToSave = fileChooser.getCurrentDirectory();
            try {
                CSVExporter.writeCSVColumns((XYChart)this.chart, theFileToSave.getCanonicalPath() + File.separatorChar);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class XChartPanelPopupMenu
    extends JPopupMenu {
        final JMenuItem saveAsMenuItem;
        JMenuItem exportAsMenuItem;

        public XChartPanelPopupMenu() {
            this.saveAsMenuItem = new JMenuItem(XChartPanel.this.saveAsString);
            this.saveAsMenuItem.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    XChartPanel.this.showSaveAsDialog();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.add(this.saveAsMenuItem);
            if (XChartPanel.this.chart instanceof XYChart) {
                this.exportAsMenuItem = new JMenuItem(XChartPanel.this.exportAsString);
                this.exportAsMenuItem.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        XChartPanel.this.showExportAsDialog();
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }
                });
                this.add(this.exportAsMenuItem);
            }
        }
    }

    private class PopUpMenuClickListener
    extends MouseAdapter {
        private PopUpMenuClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        private void doPop(MouseEvent e) {
            XChartPanelPopupMenu menu = new XChartPanelPopupMenu();
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class SuffixSaveFilter
    extends FileFilter {
        private final String suffix;

        public SuffixSaveFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            return s.endsWith("." + this.suffix) || s.endsWith("." + this.suffix.toUpperCase());
        }

        @Override
        public String getDescription() {
            return "*." + this.suffix + ",*." + this.suffix.toUpperCase();
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("export");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XChartPanel.this.showExportAsDialog();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XChartPanel.this.showSaveAsDialog();
        }
    }
}

