/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.hhp.plot;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.orpiske.hhp.plot.HdrData;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdrReader {
    private static final Logger logger = LoggerFactory.getLogger(HdrReader.class);

    public HdrData read(String filename) throws IOException {
        FileReader in = new FileReader(filename);
        HdrData ret = new HdrData();
        List<Double> value = ret.getValue();
        List<Double> percentile = ret.getPercentile();
        CSVParser records = CSVFormat.RFC4180.withCommentMarker('#').withFirstRecordAsHeader().parse((Reader)in);
        for (CSVRecord record : records) {
            String valueStr = record.get(0);
            String percentileStr = record.get(1);
            logger.debug("Value: {}", (Object)valueStr);
            logger.debug("Percentile: {}", (Object)percentileStr);
            value.add(Double.parseDouble(valueStr));
            percentile.add(Double.parseDouble(percentileStr) * 100.0);
        }
        return ret;
    }
}

