/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.hhp.plot;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import net.orpiske.hhp.plot.exceptions.HdrEmptyDataSet;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class HdrPlotter {
    private static final String SERIES_NAME = "Percentiles range";
    private final String baseName;
    private int outputWidth = 1200;
    private int outputHeight = 700;
    private boolean plotGridLinesVisible = true;
    private String timeUnit = "microseconds";

    public HdrPlotter(String baseName) {
        this.baseName = baseName;
    }

    public HdrPlotter(String baseName, String timeUnit) {
        this.baseName = baseName;
        if (timeUnit != null) {
            this.timeUnit = timeUnit;
        }
    }

    private XYChart buildCommonChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(this.outputWidth)).height(this.outputHeight)).title("Latency by Percentile Distribution")).xAxisTitle("Percentiles").yAxisTitle("Latency (" + this.timeUnit + ")").build();
        ((XYStyler)chart.getStyler()).setPlotBackgroundColor(ChartColor.getAWTColor((ChartColor)ChartColor.WHITE));
        ((XYStyler)chart.getStyler()).setChartBackgroundColor(Color.WHITE);
        ((XYStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(new Color(0, 222, 0));
        ((XYStyler)chart.getStyler()).setPlotGridLinesVisible(this.plotGridLinesVisible);
        ((XYStyler)chart.getStyler()).setYAxisTickMarkSpacingHint(15);
        ((XYStyler)chart.getStyler()).setXAxisTickMarkSpacingHint(10);
        ((XYStyler)chart.getStyler()).setXAxisMax(Double.valueOf(100.0));
        ((XYStyler)chart.getStyler()).setXAxisLabelRotation(45);
        ((XYStyler)chart.getStyler()).setAxisTickMarkLength(15);
        ((XYStyler)chart.getStyler()).setPlotMargin(0);
        ((XYStyler)chart.getStyler()).setPlotContentSize(0.99);
        ((XYStyler)chart.getStyler()).setChartTitleFont(new Font("Verdana", 1, 14));
        ((XYStyler)chart.getStyler()).setLegendFont(new Font("Verdana", 0, 12));
        ((XYStyler)chart.getStyler()).setAxisTitleFont(new Font("Verdana", 0, 12));
        ((XYStyler)chart.getStyler()).setAxisTickLabelsFont(new Font("Verdana", 0, 10));
        return chart;
    }

    private void plot99(List<Double> xData, List<Double> yData) throws IOException {
        XYChart chart = this.buildCommonChart();
        ((XYStyler)chart.getStyler()).setXAxisMin(Double.valueOf(99.0));
        XYSeries series = chart.addSeries(SERIES_NAME, xData, yData);
        series.setLineColor(XChartSeriesColors.BLUE);
        series.setMarkerColor(Color.LIGHT_GRAY);
        series.setMarker(SeriesMarkers.NONE);
        series.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_99.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plot90(List<Double> xData, List<Double> yData) throws IOException {
        XYChart chart = this.buildCommonChart();
        ((XYStyler)chart.getStyler()).setXAxisMin(Double.valueOf(90.0));
        XYSeries series = chart.addSeries(SERIES_NAME, xData, yData);
        series.setLineColor(XChartSeriesColors.BLUE);
        series.setMarkerColor(Color.LIGHT_GRAY);
        series.setMarker(SeriesMarkers.NONE);
        series.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_90.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotAll(List<Double> xData, List<Double> yData) throws IOException {
        XYChart chart = this.buildCommonChart();
        ((XYStyler)chart.getStyler()).setXAxisMin(Double.valueOf(5.0));
        XYSeries series = chart.addSeries(SERIES_NAME, xData, yData);
        series.setLineColor(XChartSeriesColors.BLUE);
        series.setMarkerColor(Color.LIGHT_GRAY);
        series.setMarker(SeriesMarkers.NONE);
        series.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_all.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    public void plot(List<Double> xData, List<Double> yData) throws IOException, HdrEmptyDataSet {
        if (xData == null || xData.size() == 0) {
            throw new HdrEmptyDataSet("The 'X' column data set is empty");
        }
        if (yData == null || yData.size() == 0) {
            throw new HdrEmptyDataSet("The 'Y' column data set is empty");
        }
        this.plotAll(xData, yData);
        this.plot90(xData, yData);
        this.plot99(xData, yData);
    }

    public void setOutputWidth(int outputWidth) {
        this.outputWidth = outputWidth;
    }

    public void setOutputHeight(int outputHeight) {
        this.outputHeight = outputHeight;
    }

    public void setPlotGridLinesVisible(boolean plotGridLinesVisible) {
        this.plotGridLinesVisible = plotGridLinesVisible;
    }
}

