/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.hhp.main;

import net.orpiske.hhp.plot.HdrData;
import net.orpiske.hhp.plot.HdrLogProcessorWrapper;
import net.orpiske.hhp.plot.HdrPlotter;
import net.orpiske.hhp.plot.HdrReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FilenameUtils;

public class Main {
    private static CommandLine cmdLine;
    private static String fileName;
    private static String timeUnit;
    private static String unitRate;

    private static void help(Options options, int code) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("hdr-histogram-plotter 1.0.0", options);
        System.exit(code);
    }

    private static void processCommand(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "prints the help");
        options.addOption("f", "file", true, "file to plot");
        options.addOption("t", "time-unit", true, "time unit to use (milliseconds, microseconds, etc)");
        options.addOption("r", "unit-rate", true, "the unit rate to use (default = 1)");
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            Main.help(options, -1);
        }
        if (cmdLine.hasOption("help")) {
            Main.help(options, 0);
        }
        if ((fileName = cmdLine.getOptionValue('f')) == null) {
            Main.help(options, -1);
        }
        if ((timeUnit = cmdLine.getOptionValue('t')) == null) {
            Main.help(options, -1);
        }
        if ((unitRate = cmdLine.getOptionValue('r')) == null) {
            unitRate = "1";
        }
    }

    public static void main(String[] args) {
        Main.processCommand(args);
        try {
            HdrLogProcessorWrapper processorWrapper = new HdrLogProcessorWrapper(unitRate);
            String csvFile = processorWrapper.convertLog(fileName);
            HdrReader reader = new HdrReader();
            HdrData hdrData = reader.read(csvFile);
            HdrPlotter plotter = new HdrPlotter(FilenameUtils.removeExtension(fileName), timeUnit);
            plotter.plot(hdrData.getPercentile(), hdrData.getValue());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        System.exit(1);
    }
}

