/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Variable {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private final JinjavaInterpreter interpreter;
    private final String name;
    private final List<String> chainList;

    public Variable(JinjavaInterpreter interpreter, String variable) {
        this.interpreter = interpreter;
        if (variable.indexOf(46) == -1) {
            this.name = variable;
            this.chainList = Collections.emptyList();
        } else {
            ArrayList parts = Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)variable));
            this.name = (String)parts.get(0);
            this.chainList = parts.subList(1, parts.size());
        }
    }

    public String getName() {
        return this.name;
    }

    public Object resolve(Object value) {
        return this.interpreter.resolveProperty(value, this.chainList);
    }

    public String toString() {
        return "<Variable: " + this.name + ">";
    }
}

