/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree.parse;

import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.util.WhitespaceUtils;

public class TagToken
extends Token {
    private static final long serialVersionUID = -4927751270481832992L;
    private String tagName;
    private String helpers;

    public TagToken(String image, int lineNumber, int startPosition) {
        super(image, lineNumber, startPosition);
    }

    @Override
    public int getType() {
        return 37;
    }

    @Override
    protected void parse() {
        int pos;
        if (this.image.length() < 4) {
            throw new TemplateSyntaxException(this.image, "Malformed tag token", this.getLineNumber(), this.getStartPosition());
        }
        this.content = this.image.substring(2, this.image.length() - 2);
        if (WhitespaceUtils.startsWith(this.content, "-")) {
            this.setLeftTrim(true);
            this.content = WhitespaceUtils.unwrap(this.content, "-", "");
        }
        if (WhitespaceUtils.endsWith(this.content, "-")) {
            this.setRightTrim(true);
            this.content = WhitespaceUtils.unwrap(this.content, "", "-");
        }
        int nameStart = -1;
        int len = this.content.length();
        for (pos = 0; pos < len; ++pos) {
            char c = this.content.charAt(pos);
            if (nameStart == -1 && Character.isJavaIdentifierStart(c)) {
                nameStart = pos;
                continue;
            }
            if (nameStart != -1 && !Character.isJavaIdentifierPart(c)) break;
        }
        if (pos < this.content.length()) {
            this.tagName = this.content.substring(nameStart, pos).toLowerCase();
            this.helpers = this.content.substring(pos);
        } else {
            this.tagName = this.content.toLowerCase().trim();
            this.helpers = "";
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getHelpers() {
        return this.helpers;
    }

    @Override
    public String toString() {
        if (this.helpers.length() == 0) {
            return "{% " + this.tagName + " %}";
        }
        return "{% " + this.tagName + " " + this.helpers + " %}";
    }
}

