/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.util.ObjectTruthValue;
import org.apache.commons.lang3.BooleanUtils;

@JinjavaDoc(value="If the value is undefined it will return the passed default value, otherwise the value of the variable", params={@JinjavaParam(value="value", desc="The variable or value to test"), @JinjavaParam(value="default_value", desc="Value to print when variable is not defined"), @JinjavaParam(value="boolean", type="boolean", defaultValue="False", desc="Set to True to use with variables which evaluate to false")}, snippets={@JinjavaSnippet(desc="This will output the value of my_variable if the variable was defined, otherwise 'my_variable is not defined'", code="{{ my_variable|default('my_variable is not defined') }}"), @JinjavaSnippet(desc="If you want to use default with variables that evaluate to false you have to set the second parameter to true", code="{{ ''|default('the string was empty', true) }}")})
public class DefaultFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        boolean truthy = false;
        if (arg.length == 0) {
            throw new InterpretException("default filter requires 1 or 2 args");
        }
        if (arg.length == 2) {
            truthy = BooleanUtils.toBoolean((String)arg[1]);
        }
        if (truthy ? ObjectTruthValue.evaluate(object) : object != null) {
            return object;
        }
        return arg[0];
    }

    @Override
    public String getName() {
        return "default";
    }
}

