/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.TemplateError;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FatalTemplateErrorsException
extends InterpretException {
    private static final long serialVersionUID = 1L;
    private final String template;
    private final Iterable<TemplateError> errors;

    public FatalTemplateErrorsException(String template, Iterable<TemplateError> errors) {
        super(FatalTemplateErrorsException.generateMessage(errors));
        this.template = template;
        this.errors = errors;
    }

    private static String generateMessage(Iterable<TemplateError> errors) {
        StringBuilder msg = new StringBuilder();
        for (TemplateError error : errors) {
            msg.append(error.toString()).append('\n');
            if (error.getException() == null) continue;
            msg.append(ExceptionUtils.getStackTrace((Throwable)error.getException())).append('\n');
        }
        return msg.toString();
    }

    public String getTemplate() {
        return this.template;
    }

    public Iterable<TemplateError> getErrors() {
        return this.errors;
    }
}

