/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import jinjava.javax.el.BeanELResolver;
import jinjava.javax.el.ELContext;
import jinjava.javax.el.MethodNotFoundException;

public class JinjavaBeanELResolver
extends BeanELResolver {
    private static final Set<String> RESTRICTED_PROPERTIES = ImmutableSet.builder().add((Object)"class").build();
    private static final Set<String> RESTRICTED_METHODS = ImmutableSet.builder().add((Object)"clone").add((Object)"hashCode").add((Object)"notify").add((Object)"notifyAll").add((Object)"wait").build();

    public JinjavaBeanELResolver() {
    }

    public JinjavaBeanELResolver(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        return super.getType(context, base, this.validatePropertyName(property));
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        return super.getValue(context, base, this.validatePropertyName(property));
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return super.isReadOnly(context, base, this.validatePropertyName(property));
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        super.setValue(context, base, this.validatePropertyName(property), value);
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (method == null || RESTRICTED_METHODS.contains(method.toString())) {
            throw new MethodNotFoundException("Cannot find method '" + method + "' in " + base.getClass());
        }
        return super.invoke(context, base, method, paramTypes, params);
    }

    private String validatePropertyName(Object property) {
        String propertyName = this.transformPropertyName(property);
        if (RESTRICTED_PROPERTIES.contains(propertyName)) {
            return null;
        }
        return propertyName;
    }

    private String transformPropertyName(Object property) {
        if (property == null) {
            return null;
        }
        String propertyStr = property.toString();
        if (propertyStr.indexOf(95) == -1) {
            return propertyStr;
        }
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, propertyStr);
    }
}

