/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.google.common.collect.Lists;
import com.hubspot.jinjava.el.ext.AbsOperator;
import com.hubspot.jinjava.el.ext.AdditionOperator;
import com.hubspot.jinjava.el.ext.AstDict;
import com.hubspot.jinjava.el.ext.AstList;
import com.hubspot.jinjava.el.ext.AstMacroFunction;
import com.hubspot.jinjava.el.ext.AstRangeBracket;
import com.hubspot.jinjava.el.ext.AstTuple;
import com.hubspot.jinjava.el.ext.CollectionMembershipOperator;
import com.hubspot.jinjava.el.ext.ExtendedScanner;
import com.hubspot.jinjava.el.ext.NamedParameterOperator;
import com.hubspot.jinjava.el.ext.OrOperator;
import com.hubspot.jinjava.el.ext.PowerOfOperator;
import com.hubspot.jinjava.el.ext.StringConcatOperator;
import com.hubspot.jinjava.el.ext.TruncDivOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import jinjava.de.odysseus.el.tree.impl.Builder;
import jinjava.de.odysseus.el.tree.impl.Parser;
import jinjava.de.odysseus.el.tree.impl.Scanner;
import jinjava.de.odysseus.el.tree.impl.ast.AstBinary;
import jinjava.de.odysseus.el.tree.impl.ast.AstBracket;
import jinjava.de.odysseus.el.tree.impl.ast.AstDot;
import jinjava.de.odysseus.el.tree.impl.ast.AstFunction;
import jinjava.de.odysseus.el.tree.impl.ast.AstLiteral;
import jinjava.de.odysseus.el.tree.impl.ast.AstNested;
import jinjava.de.odysseus.el.tree.impl.ast.AstNode;
import jinjava.de.odysseus.el.tree.impl.ast.AstNull;
import jinjava.de.odysseus.el.tree.impl.ast.AstParameters;
import jinjava.javax.el.ELException;

public class ExtendedParser
extends Parser {
    public static final String INTERPRETER = "____int3rpr3t3r____";
    public static final String FILTER_PREFIX = "filter:";
    public static final String EXPTEST_PREFIX = "exptest:";
    static final Scanner.ExtensionToken PIPE = new Scanner.ExtensionToken("|");
    static final Scanner.ExtensionToken IS = new Scanner.ExtensionToken("is");
    static final Scanner.Token IF = new Scanner.Token(Scanner.Symbol.QUESTION, "if");
    static final Scanner.Token ELSE = new Scanner.Token(Scanner.Symbol.COLON, "else");
    static final Scanner.ExtensionToken LITERAL_DICT_START = new Scanner.ExtensionToken("{");
    static final Scanner.ExtensionToken LITERAL_DICT_END = new Scanner.ExtensionToken("}");
    static final Scanner.ExtensionToken TRUNC_DIV = new Scanner.ExtensionToken("//");
    static final Scanner.ExtensionToken POWER_OF = new Scanner.ExtensionToken("**");
    private static final Parser.ExtensionHandler NULL_EXT_HANDLER;

    public ExtendedParser(Builder context, String input) {
        super(context, input);
        this.putExtensionHandler(AbsOperator.TOKEN, AbsOperator.HANDLER);
        this.putExtensionHandler(NamedParameterOperator.TOKEN, NamedParameterOperator.HANDLER);
        this.putExtensionHandler(StringConcatOperator.TOKEN, StringConcatOperator.HANDLER);
        this.putExtensionHandler(TruncDivOperator.TOKEN, TruncDivOperator.HANDLER);
        this.putExtensionHandler(PowerOfOperator.TOKEN, PowerOfOperator.HANDLER);
        this.putExtensionHandler(CollectionMembershipOperator.TOKEN, CollectionMembershipOperator.HANDLER);
        this.putExtensionHandler(PIPE, new Parser.ExtensionHandler(Parser.ExtensionPoint.AND){

            @Override
            public AstNode createAstNode(AstNode ... children) {
                throw new ELException("Illegal use of '|' operator");
            }
        });
        this.putExtensionHandler(LITERAL_DICT_START, NULL_EXT_HANDLER);
        this.putExtensionHandler(LITERAL_DICT_END, NULL_EXT_HANDLER);
    }

    protected AstNode interpreter() {
        return this.identifier(INTERPRETER);
    }

    @Override
    protected AstNode expr(boolean required) throws Scanner.ScanException, Parser.ParseException {
        AstNode v = this.or(required);
        if (v == null) {
            return null;
        }
        if (this.getToken().getSymbol() == Scanner.Symbol.QUESTION) {
            if (!this.getToken().getImage().equals("if")) {
                this.consumeToken();
                AstNode a = this.expr(true);
                this.consumeToken(Scanner.Symbol.COLON);
                AstNode b = this.expr(true);
                v = this.createAstChoice(v, a, b);
            } else {
                this.consumeToken();
                AstNode cond = this.expr(true);
                AstNode elseNode = new AstNull();
                if (this.getToken().getImage().equals("else")) {
                    this.consumeToken();
                    elseNode = this.expr(true);
                }
                v = this.createAstChoice(cond, v, elseNode);
            }
        }
        return v;
    }

    @Override
    protected AstNode or(boolean required) throws Scanner.ScanException, Parser.ParseException {
        AstNode v = this.and(required);
        if (v == null) {
            return null;
        }
        block4: while (true) {
            switch (this.getToken().getSymbol()) {
                case OR: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.and(true), OrOperator.OP);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.getToken()).getExtensionPoint() != Parser.ExtensionPoint.OR) break block4;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.and(true));
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    @Override
    protected AstNode add(boolean required) throws Scanner.ScanException, Parser.ParseException {
        AstNode v = this.mul(required);
        if (v == null) {
            return null;
        }
        block5: while (true) {
            switch (this.getToken().getSymbol()) {
                case PLUS: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.mul(true), AdditionOperator.OP);
                    continue block5;
                }
                case MINUS: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.mul(true), AstBinary.SUB);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.getToken()).getExtensionPoint() != Parser.ExtensionPoint.ADD) break block5;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.mul(true));
                    continue block5;
                }
            }
            break;
        }
        return v;
    }

    @Override
    protected AstParameters params() throws Scanner.ScanException, Parser.ParseException {
        return this.params(Scanner.Symbol.LPAREN, Scanner.Symbol.RPAREN);
    }

    protected AstParameters params(Scanner.Symbol left, Scanner.Symbol right) throws Scanner.ScanException, Parser.ParseException {
        this.consumeToken(left);
        List<AstNode> l = Collections.emptyList();
        AstNode v = this.expr(false);
        if (v != null) {
            l = new ArrayList();
            l.add(v);
            while (this.getToken().getSymbol() == Scanner.Symbol.COMMA) {
                this.consumeToken();
                l.add(this.expr(true));
            }
        }
        this.consumeToken(right);
        return new AstParameters(l);
    }

    protected AstDict dict() throws Scanner.ScanException, Parser.ParseException {
        this.consumeToken();
        LinkedHashMap<AstNode, AstNode> dict = new LinkedHashMap<AstNode, AstNode>();
        AstNode k = this.expr(false);
        if (k != null) {
            this.consumeToken(Scanner.Symbol.COLON);
            AstNode v = this.expr(true);
            dict.put(k, v);
            while (this.getToken().getSymbol() == Scanner.Symbol.COMMA) {
                this.consumeToken();
                k = this.expr(false);
                if (k == null) continue;
                this.consumeToken(Scanner.Symbol.COLON);
                v = this.expr(true);
                dict.put(k, v);
            }
        }
        if (!this.getToken().getImage().equals("}")) {
            this.fail("}");
        }
        this.consumeToken();
        return new AstDict(dict);
    }

    @Override
    protected AstFunction createAstFunction(String name, int index, AstParameters params) {
        return new AstMacroFunction(name, index, params, this.context.isEnabled(Builder.Feature.VARARGS));
    }

    @Override
    protected AstNode nonliteral() throws Scanner.ScanException, Parser.ParseException {
        AstNode v = null;
        switch (this.getToken().getSymbol()) {
            case IDENTIFIER: {
                String name = this.consumeToken().getImage();
                if (this.getToken().getSymbol() == Scanner.Symbol.COLON && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER && this.lookahead(1).getSymbol() == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    name = name + ":" + this.getToken().getImage();
                    this.consumeToken();
                }
                if (this.getToken().getSymbol() == Scanner.Symbol.LPAREN) {
                    v = this.function(name, this.params());
                    break;
                }
                v = this.identifier(name);
                break;
            }
            case LPAREN: {
                Scanner.Symbol s;
                int i = 0;
                do {
                    if ((s = this.lookahead(i++).getSymbol()) != Scanner.Symbol.COMMA) continue;
                    return new AstTuple(this.params());
                } while (s != Scanner.Symbol.RPAREN && s != Scanner.Symbol.EOF);
                this.consumeToken();
                v = this.expr(true);
                this.consumeToken(Scanner.Symbol.RPAREN);
                v = new AstNested(v);
                break;
            }
        }
        return v;
    }

    @Override
    protected AstNode literal() throws Scanner.ScanException, Parser.ParseException {
        AstLiteral v = null;
        switch (this.getToken().getSymbol()) {
            case LBRACK: {
                v = new AstList(this.params(Scanner.Symbol.LBRACK, Scanner.Symbol.RBRACK));
                break;
            }
            case LPAREN: {
                v = new AstTuple(this.params());
                break;
            }
            case EXTENSION: {
                if (this.getToken() == LITERAL_DICT_START) {
                    v = this.dict();
                    break;
                }
                if (this.getToken() != LITERAL_DICT_END) break;
                return null;
            }
        }
        if (v != null) {
            return v;
        }
        return super.literal();
    }

    protected AstRangeBracket createAstRangeBracket(AstNode base, AstNode rangeStart, AstNode rangeMax, boolean lvalue, boolean strict) {
        return new AstRangeBracket(base, rangeStart, rangeMax, lvalue, strict, this.context.isEnabled(Builder.Feature.IGNORE_RETURN_TYPE));
    }

    @Override
    protected AstNode value() throws Scanner.ScanException, Parser.ParseException {
        boolean lvalue = true;
        AstNode v = this.nonliteral();
        if (v == null) {
            v = this.literal();
            if (v == null) {
                return null;
            }
            lvalue = false;
        }
        block4: while (true) {
            switch (this.getToken().getSymbol()) {
                case DOT: {
                    this.consumeToken();
                    String name = this.consumeToken(Scanner.Symbol.IDENTIFIER).getImage();
                    AstDot dot = this.createAstDot(v, name, lvalue);
                    if (this.getToken().getSymbol() == Scanner.Symbol.LPAREN && this.context.isEnabled(Builder.Feature.METHOD_INVOCATIONS)) {
                        v = this.createAstMethod(dot, this.params());
                        continue block4;
                    }
                    v = dot;
                    continue block4;
                }
                case LBRACK: {
                    this.consumeToken();
                    AstNode property = this.expr(false);
                    boolean strict = !this.context.isEnabled(Builder.Feature.NULL_PROPERTIES);
                    Scanner.Token nextToken = this.consumeToken();
                    if (nextToken.getSymbol() == Scanner.Symbol.COLON) {
                        AstNode rangeMax = this.expr(false);
                        this.consumeToken(Scanner.Symbol.RBRACK);
                        v = this.createAstRangeBracket(v, property, rangeMax, lvalue, strict);
                        continue block4;
                    }
                    if (nextToken.getSymbol() == Scanner.Symbol.RBRACK) {
                        AstBracket bracket = this.createAstBracket(v, property, lvalue, strict);
                        if (this.getToken().getSymbol() == Scanner.Symbol.LPAREN && this.context.isEnabled(Builder.Feature.METHOD_INVOCATIONS)) {
                            v = this.createAstMethod(bracket, this.params());
                            continue block4;
                        }
                        v = bracket;
                        continue block4;
                    }
                    this.fail(Scanner.Symbol.RBRACK);
                    continue block4;
                }
            }
            break;
        }
        if ("|".equals(this.getToken().getImage()) && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER) {
            do {
                this.consumeToken();
                String filterName = this.consumeToken().getImage();
                ArrayList filterParams = Lists.newArrayList((Object[])new AstNode[]{v, this.interpreter()});
                if (this.getToken().getSymbol() == Scanner.Symbol.LPAREN) {
                    AstParameters astParameters = this.params();
                    for (int i = 0; i < astParameters.getCardinality(); ++i) {
                        filterParams.add(astParameters.getChild(i));
                    }
                }
                AstDot filterProperty = this.createAstDot(this.identifier(FILTER_PREFIX + filterName), "filter", true);
                v = this.createAstMethod(filterProperty, new AstParameters(filterParams));
            } while ("|".equals(this.getToken().getImage()));
        } else if ("is".equals(this.getToken().getImage()) && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER) {
            this.consumeToken();
            String exptestName = this.consumeToken().getImage();
            ArrayList exptestParams = Lists.newArrayList((Object[])new AstNode[]{v, this.interpreter()});
            AstNode arg = this.expr(false);
            if (arg != null) {
                exptestParams.add(arg);
            }
            AstDot exptestProperty = this.createAstDot(this.identifier(EXPTEST_PREFIX + exptestName), "evaluate", true);
            v = this.createAstMethod(exptestProperty, new AstParameters(exptestParams));
        } else if ("//".equals(this.getToken().getImage()) && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER) {
            this.consumeToken();
            v = this.createAstBinary(v, this.mul(true), TruncDivOperator.OP);
        } else if ("**".equals(this.getToken().getImage()) && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER) {
            this.consumeToken();
            v = this.createAstBinary(v, this.mul(true), PowerOfOperator.OP);
        }
        return v;
    }

    @Override
    protected Scanner createScanner(String expression) {
        return new ExtendedScanner(expression);
    }

    static {
        ExtendedScanner.addKeyToken(IF);
        ExtendedScanner.addKeyToken(ELSE);
        ExtendedScanner.addKeyToken(TruncDivOperator.TOKEN);
        ExtendedScanner.addKeyToken(PowerOfOperator.TOKEN);
        ExtendedScanner.addKeyToken(CollectionMembershipOperator.TOKEN);
        NULL_EXT_HANDLER = new Parser.ExtensionHandler(null){

            @Override
            public AstNode createAstNode(AstNode ... children) {
                return null;
            }
        };
    }
}

