/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.el.JinjavaELContext;
import com.hubspot.jinjava.el.JinjavaInterpreterResolver;
import com.hubspot.jinjava.el.ext.NamedParameter;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnknownTokenException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import java.util.List;
import java.util.Map;
import jinjava.de.odysseus.el.tree.TreeBuilderException;
import jinjava.javax.el.ELException;
import jinjava.javax.el.ExpressionFactory;
import jinjava.javax.el.PropertyNotFoundException;
import jinjava.javax.el.ValueExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExpressionResolver {
    private final JinjavaInterpreter interpreter;
    private final ExpressionFactory expressionFactory;
    private final JinjavaInterpreterResolver resolver;
    private final JinjavaELContext elContext;

    public ExpressionResolver(JinjavaInterpreter interpreter, ExpressionFactory expressionFactory) {
        this.interpreter = interpreter;
        this.expressionFactory = expressionFactory;
        this.resolver = new JinjavaInterpreterResolver(interpreter);
        this.elContext = new JinjavaELContext(this.resolver);
        for (ELFunctionDefinition fn : interpreter.getContext().getAllFunctions()) {
            this.elContext.setFunction(fn.getNamespace(), fn.getLocalName(), fn.getMethod());
        }
    }

    public Object resolveExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        this.interpreter.getContext().addResolvedExpression(expression.trim());
        try {
            String elExpression = "#{" + expression.trim() + "}";
            ValueExpression valueExp = this.expressionFactory.createValueExpression(this.elContext, elExpression, Object.class);
            Object result = valueExp.getValue(this.elContext);
            this.validateResult(result);
            return result;
        }
        catch (PropertyNotFoundException e) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.UNKNOWN, TemplateError.ErrorItem.PROPERTY, e.getMessage(), "", this.interpreter.getLineNumber(), -1, e, BasicTemplateErrorCategory.UNKNOWN, (Map<String, String>)ImmutableMap.of((Object)"exception", (Object)e.getMessage())));
        }
        catch (TreeBuilderException e) {
            this.interpreter.addError(TemplateError.fromException(new TemplateSyntaxException(expression, "Error parsing '" + expression + "': " + StringUtils.substringAfter((String)e.getMessage(), (String)"': "), this.interpreter.getLineNumber(), e.getPosition(), e)));
        }
        catch (ELException e) {
            this.interpreter.addError(TemplateError.fromException(new TemplateSyntaxException(expression, e.getMessage(), this.interpreter.getLineNumber(), e)));
        }
        catch (DisabledException e) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.DISABLED, TemplateError.ErrorItem.FUNCTION, e.getMessage(), expression, this.interpreter.getLineNumber(), -1, e));
        }
        catch (UnknownTokenException e) {
            throw e;
        }
        catch (Exception e) {
            this.interpreter.addError(TemplateError.fromException(new InterpretException(String.format("Error resolving expression [%s]: " + ExceptionUtils.getRootCauseMessage((Throwable)e), expression), e, this.interpreter.getLineNumber())));
        }
        return "";
    }

    private void validateResult(Object result) {
        if (result instanceof NamedParameter) {
            throw new ELException("Unexpected '=' operator (use {% set %} tag for variable assignment)");
        }
    }

    public Object resolveProperty(Object object, List<String> propertyNames) {
        Object value = this.resolver.wrap(object);
        for (String propertyName : propertyNames) {
            if (value == null) {
                return null;
            }
            value = this.resolver.getValue(this.elContext, value, propertyName);
        }
        return value;
    }
}

