/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.processors;

import java.io.File;
import java.util.List;
import net.orpiske.mpt.reports.files.ReportFile;
import net.orpiske.mpt.reports.processors.ReportFileProcessor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCleaner
implements ReportFileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DiskCleaner.class);
    private static final String FILE_EXTENSION_CSV = "csv";

    private void clean(ReportFile reportFile) {
        String ext;
        File sourceFile = reportFile.getSourceFile();
        switch (ext = FilenameUtils.getExtension((String)sourceFile.getName())) {
            case "hdr": 
            case "gz": 
            case "csv": {
                logger.debug("Cleaning file {}", (Object)sourceFile.getPath());
                FileUtils.deleteQuietly((File)sourceFile);
            }
        }
    }

    @Override
    public void process(List<ReportFile> reportFiles) {
        reportFiles.stream().forEach(this::clean);
    }
}

