/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.plotter;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import net.orpiske.mdp.plot.DateFilter;
import net.orpiske.mdp.plot.FastRateReader;
import net.orpiske.mdp.plot.Filter;
import net.orpiske.mdp.plot.FilteredRateDataProcessor;
import net.orpiske.mdp.plot.Processor;
import net.orpiske.mdp.plot.RateData;
import net.orpiske.mdp.plot.RatePlotter;
import net.orpiske.mdp.plot.RatePropertyWriter;
import net.orpiske.mdp.plot.RateReader;
import net.orpiske.mpt.reports.plotter.PlotterWrapper;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatePlotterWrapper
implements PlotterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RatePlotterWrapper.class);
    private static final DateFilter dateFilter = new DateFilter(new GregorianCalendar(2000, 0, 1).getTime());
    private FilteredRateDataProcessor rateDataProcessor = new FilteredRateDataProcessor((Filter)dateFilter);
    private RateReader rateReader = new FastRateReader((Processor)this.rateDataProcessor);

    @Override
    public boolean plot(File file) {
        logger.debug("Plotting MPT compressed file {}", (Object)file.getPath());
        String baseName = FilenameUtils.removeExtension((String)file.getPath());
        baseName = FilenameUtils.removeExtension((String)baseName);
        try {
            if (!file.exists()) {
                throw new IOException("File " + file.getPath() + " does not exist");
            }
            this.rateReader.read(file.getPath());
            RateData rateData = this.rateDataProcessor.getRateData();
            RatePlotter plotter = new RatePlotter(FilenameUtils.removeExtension((String)baseName));
            List ratePeriods = rateData.getRatePeriods();
            logger.info("Number of rate records to plot: {}", (Object)ratePeriods.size());
            logger.info("Number of rate records in error: {}", (Object)rateData.getErrorCount());
            if (logger.isDebugEnabled()) {
                for (Date d : ratePeriods) {
                    logger.debug("Adding date record for plotting: {}", (Object)d);
                }
            }
            plotter.setOutputWidth(1024);
            plotter.setOutputHeight(600);
            plotter.plot(ratePeriods, rateData.getRateValues());
            RatePropertyWriter.write((RateData)rateData, (File)file.getParentFile());
            return true;
        }
        catch (Throwable t) {
            this.handlePlotException(file, t);
            return false;
        }
    }
}

