/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.plotter;

import java.io.File;
import java.util.Properties;
import net.orpiske.mpt.reports.files.MptReportFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PlotterWrapper {
    public boolean plot(File var1);

    default public void handlePlotException(File file, Throwable t) {
        Logger logger = LoggerFactory.getLogger(PlotterWrapper.class);
        logger.error("Unable to plot report file {}: {}", (Object)file.getPath(), (Object)t.getMessage());
        logger.trace("Exception: ", t);
        MptReportFile reportFile = new MptReportFile(null, file);
        reportFile.setReportSuccessful(false);
        reportFile.setReportFailure(t);
        Properties prop = new Properties();
        prop.setProperty("error", "true");
        if (t != null) {
            String message = t.getMessage();
            if (message != null) {
                prop.setProperty("message", message);
            } else {
                prop.setProperty("message", "Undefined error: " + t.getClass());
            }
        } else {
            prop.setProperty("message", "Undefined error");
        }
    }
}

