/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.plotter;

import java.io.File;
import java.io.IOException;
import net.orpiske.hhp.plot.HdrData;
import net.orpiske.hhp.plot.HdrLogProcessorWrapper;
import net.orpiske.hhp.plot.HdrPlotter;
import net.orpiske.hhp.plot.HdrReader;
import net.orpiske.mpt.reports.plotter.PlotterWrapper;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdrPlotterWrapper
implements PlotterWrapper {
    private static Logger logger = LoggerFactory.getLogger(HdrPlotterWrapper.class);
    private static String DEFAULT_UNIT_RATE = "1000";
    private HdrLogProcessorWrapper processorWrapper;
    private HdrReader reader = new HdrReader();

    public HdrPlotterWrapper() {
        this(DEFAULT_UNIT_RATE);
    }

    public HdrPlotterWrapper(String unitRate) {
        this.processorWrapper = new HdrLogProcessorWrapper(unitRate);
    }

    @Override
    public boolean plot(File file) {
        logger.debug("Plotting HDR file {}", (Object)file.getPath());
        try {
            if (!file.exists()) {
                throw new IOException("File " + file.getPath() + " does not exist");
            }
            String csvFile = this.processorWrapper.convertLog(file.getPath());
            HdrData hdrData = this.reader.read(csvFile);
            HdrPlotter plotter = new HdrPlotter(FilenameUtils.removeExtension((String)file.getPath()));
            plotter.setOutputWidth(1024);
            plotter.setOutputHeight(600);
            plotter.plot(hdrData.getPercentile(), hdrData.getValue());
            return true;
        }
        catch (Throwable t) {
            FilenameUtils.removeExtension((String)file.getPath());
            this.handlePlotException(file, t);
            return false;
        }
    }
}

