/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.plotter;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.orpiske.bmic.plot.BmicData;
import net.orpiske.bmic.plot.BmicPlotter;
import net.orpiske.bmic.plot.BmicReader;
import net.orpiske.mpt.reports.plotter.PlotterWrapper;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmicPlotterWrapper
implements PlotterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(BmicPlotterWrapper.class);
    private BmicReader bmicReader = new BmicReader();

    @Override
    public boolean plot(File file) {
        logger.debug("Plotting BMIC file {}", (Object)file.getPath());
        String baseName = FilenameUtils.removeExtension((String)file.getPath());
        baseName = FilenameUtils.removeExtension((String)baseName);
        try {
            if (!file.exists()) {
                throw new IOException("File " + file.getPath() + " does not exist");
            }
            BmicData bmicData = this.bmicReader.read(file.getPath());
            BmicPlotter plotter = new BmicPlotter(baseName);
            logger.debug("Number of records to plot: {} ", (Object)bmicData.getTimestamps().size());
            for (Date d : bmicData.getTimestamps()) {
                logger.debug("Adding date record for plotting: {}", (Object)d);
            }
            plotter.setOutputWidth(1024);
            plotter.setOutputHeight(600);
            plotter.plot(bmicData);
            return true;
        }
        catch (Throwable t) {
            this.handlePlotException(file, t);
            return false;
        }
    }
}

