/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.node;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.orpiske.mpt.reports.ReportDirInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeContextBuilder {
    private static Logger logger = LoggerFactory.getLogger(NodeContextBuilder.class);

    private NodeContextBuilder() {
    }

    public static Map<String, Object> toContext(ReportDirInfo reportDirInfo, File baseDir) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        File file = new File(baseDir, reportDirInfo.getReportDir());
        context.put("node", file.getName());
        context.put("nodeType", reportDirInfo.getNodeType());
        context.put("testNumber", file.getParentFile().getName());
        context.put("result", file.getParentFile().getParentFile().getName());
        context.put("reportDirInfo", reportDirInfo);
        context.put("baseDir", baseDir);
        NodeContextBuilder.loadProperties(context, new File(file, "test.properties"));
        NodeContextBuilder.loadProperties(context, new File(file, "broker.properties"));
        NodeContextBuilder.loadProperties(context, new File(file, "rate.properties"));
        return context;
    }

    private static void loadProperties(Map<String, Object> context, File testProperties) {
        if (testProperties.exists()) {
            Properties prop = new Properties();
            try (FileInputStream in = new FileInputStream(testProperties);){
                prop.load(in);
                for (Map.Entry<Object, Object> e : prop.entrySet()) {
                    logger.debug("Adding entry {} with value {}", e.getKey(), e.getValue());
                    context.put((String)e.getKey(), e.getValue());
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            logger.debug("There are no properties file at {}", (Object)testProperties.getPath());
        }
    }
}

