/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports.files;

import java.io.File;
import net.orpiske.mpt.reports.node.NodeType;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportFile {
    private static final Logger logger = LoggerFactory.getLogger(ReportFile.class);
    private File sourceFile;
    private File normalizedFile;
    private boolean reportSuccessful = true;
    private Throwable reportFailure;
    private NodeType nodeType;
    private String nodeHost;
    private int testNum;
    private boolean testSuccessful = false;

    public ReportFile(File sourceFile, File normalizedFile) {
        this.sourceFile = sourceFile;
        this.normalizedFile = normalizedFile;
        this.nodeType = NodeType.parse(normalizedFile.getName());
        File hostDir = normalizedFile.getParentFile();
        this.nodeHost = FilenameUtils.getBaseName((String)hostDir.getName());
        File testNumDir = hostDir.getParentFile();
        try {
            this.testNum = Integer.parseInt(FilenameUtils.getBaseName((String)testNumDir.getName()));
        }
        catch (RuntimeException e) {
            logger.error("Incorrect report directory layout for: {}", (Object)normalizedFile.getPath(), (Object)e);
            throw e;
        }
        File resultType = testNumDir.getParentFile();
        if (resultType.getName().contains("success")) {
            this.testSuccessful = true;
        }
    }

    public boolean isReportSuccessful() {
        return this.reportSuccessful;
    }

    public void setReportSuccessful(boolean reportSuccessful) {
        this.reportSuccessful = reportSuccessful;
    }

    public Throwable getReportFailure() {
        return this.reportFailure;
    }

    public void setReportFailure(Throwable reportFailure) {
        this.reportFailure = reportFailure;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    protected void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeHost() {
        return this.nodeHost;
    }

    public int getTestNum() {
        return this.testNum;
    }

    public boolean isTestSuccessful() {
        return this.testSuccessful;
    }

    public String getReportDir() {
        return this.normalizedFile.getParent();
    }

    public File getNormalizedFile() {
        return this.normalizedFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportFile that = (ReportFile)o;
        if (this.reportSuccessful != that.reportSuccessful) {
            return false;
        }
        if (this.testNum != that.testNum) {
            return false;
        }
        if (this.testSuccessful != that.testSuccessful) {
            return false;
        }
        if (this.normalizedFile != null ? !this.normalizedFile.equals(that.normalizedFile) : that.normalizedFile != null) {
            return false;
        }
        if (this.reportFailure != null ? !this.reportFailure.equals(that.reportFailure) : that.reportFailure != null) {
            return false;
        }
        if (this.nodeType != that.nodeType) {
            return false;
        }
        return this.nodeHost != null ? this.nodeHost.equals(that.nodeHost) : that.nodeHost == null;
    }

    public int hashCode() {
        int result = this.normalizedFile != null ? this.normalizedFile.hashCode() : 0;
        result = 31 * result + (this.reportSuccessful ? 1 : 0);
        result = 31 * result + (this.reportFailure != null ? this.reportFailure.hashCode() : 0);
        result = 31 * result + (this.nodeType != null ? this.nodeType.hashCode() : 0);
        result = 31 * result + (this.nodeHost != null ? this.nodeHost.hashCode() : 0);
        result = 31 * result + this.testNum;
        result = 31 * result + (this.testSuccessful ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ReportFile{sourceFile=" + this.sourceFile + ", normalizedFile=" + this.normalizedFile + ", reportSuccessful=" + this.reportSuccessful + ", reportFailure=" + this.reportFailure + ", nodeType=" + (Object)((Object)this.nodeType) + ", nodeHost='" + this.nodeHost + '\'' + ", testNum=" + this.testNum + ", testSuccessful=" + this.testSuccessful + '}';
    }
}

