/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import java.io.File;
import net.orpiske.mpt.utils.Downloader;
import net.orpiske.mpt.utils.contrib.resource.exceptions.ResourceExchangeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsDownloader {
    private static final Logger logger = LoggerFactory.getLogger(ReportsDownloader.class);
    private static final String LAST_SUCCESSFUL_DIR = "lastSuccessful";
    private static final String LAST_FAILED_DIR = "lastFailed";
    private String baseDir;
    private String reportTypeDir;
    private int testNum;

    public ReportsDownloader(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setTestNum(int testNum) {
        this.testNum = testNum;
    }

    public void setReportTypeDir(String reportTypeDir) {
        this.reportTypeDir = reportTypeDir;
    }

    private String buildDir(String host) {
        return this.baseDir + File.separator + this.reportTypeDir + File.separator + Integer.toString(this.testNum) + File.separator + host;
    }

    private void downloadReport(String host, String reportSource, String name) throws ResourceExchangeException {
        String baseURL = "http://" + host + ":8000/" + reportSource + "/";
        String targetURL = baseURL + name;
        logger.info("Downloading file {}", (Object)targetURL);
        Downloader.download((String)targetURL, (String)this.buildDir(host), (boolean)true);
    }

    private void downloadSenderReports(String host, String reportSource) throws ResourceExchangeException {
        String name = "senderd-rate.csv.gz";
        this.downloadReport(host, reportSource, name);
        this.downloadReport(host, reportSource, "test.properties");
    }

    private void downloadReceiverReports(String host, String reportSource) throws ResourceExchangeException {
        String tpReport = "receiverd-rate.csv.gz";
        this.downloadReport(host, reportSource, tpReport);
        String latReport = "receiverd-latency.hdr";
        this.downloadReport(host, reportSource, latReport);
        this.downloadReport(host, reportSource, "test.properties");
    }

    private void downloadInspectorReports(String host, String reportSource) throws ResourceExchangeException {
        this.downloadReport(host, reportSource, "broker-jvm-inspector.csv.gz");
        this.downloadReport(host, reportSource, "test.properties");
        this.downloadReport(host, reportSource, "broker.properties");
    }

    public void downloadLastSuccessful(String type, String host, String name) {
        try {
            if (type.equals("sender")) {
                this.downloadSenderReports(host, LAST_SUCCESSFUL_DIR);
            }
            if (type.equals("receiver")) {
                this.downloadReceiverReports(host, LAST_SUCCESSFUL_DIR);
            }
            if (type.equals("inspector")) {
                this.downloadInspectorReports(host, LAST_SUCCESSFUL_DIR);
            }
        }
        catch (Exception e) {
            logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void downloadLastFailed(String type, String host, String name) {
        try {
            if (type.equals("sender")) {
                this.downloadSenderReports(host, LAST_FAILED_DIR);
            }
            if (type.equals("receiver")) {
                this.downloadReceiverReports(host, LAST_FAILED_DIR);
            }
            if (type.equals("inspector")) {
                this.downloadInspectorReports(host, LAST_FAILED_DIR);
            }
        }
        catch (Exception e) {
            logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void downloadAny(String host, String resource) {
        try {
            block10: {
                block9: {
                    try {
                        this.downloadSenderReports(host, resource);
                    }
                    catch (ResourceExchangeException e) {
                        if (e.getCode() == 404) break block9;
                        logger.warn("Resource {} not found at {} ", (Object)resource, (Object)host);
                        throw e;
                    }
                }
                try {
                    this.downloadReceiverReports(host, resource);
                }
                catch (ResourceExchangeException e) {
                    if (e.getCode() == 404) break block10;
                    logger.warn("Resource {} not found at {} ", (Object)resource, (Object)host);
                    throw e;
                }
            }
            try {
                this.downloadInspectorReports(host, resource);
            }
            catch (ResourceExchangeException e) {
                if (e.getCode() != 404) {
                    logger.warn("Resource {} not found at {} ", (Object)resource, (Object)host);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

