/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import java.io.File;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.orpiske.mpt.reports.HdrHistogramReportFile;
import net.orpiske.mpt.reports.ReportContextBuilder;
import net.orpiske.mpt.reports.ReportDirInfo;
import net.orpiske.mpt.reports.ReportDirectoryWalker;
import net.orpiske.mpt.reports.files.BmicReportFile;
import net.orpiske.mpt.reports.files.MptReportFile;
import net.orpiske.mpt.reports.files.ReportFile;
import net.orpiske.mpt.reports.index.IndexRenderer;
import net.orpiske.mpt.reports.node.NodeContextBuilder;
import net.orpiske.mpt.reports.node.NodeReportRenderer;
import net.orpiske.mpt.reports.plotter.BmicPlotterWrapper;
import net.orpiske.mpt.reports.plotter.BmicPlotterWrapperFactory;
import net.orpiske.mpt.reports.plotter.HdrPlotterWrapper;
import net.orpiske.mpt.reports.plotter.HdrPlotterWrapperFactory;
import net.orpiske.mpt.reports.plotter.PlotterWrapperFactory;
import net.orpiske.mpt.reports.plotter.RatePlotterWrapper;
import net.orpiske.mpt.reports.plotter.RatePlotterWrapperFactory;
import net.orpiske.mpt.reports.processors.ReportFileProcessor;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ReportGenerator.class);
    private List<ReportFileProcessor> preProcessors = new LinkedList<ReportFileProcessor>();
    private List<ReportFileProcessor> postProcessors = new LinkedList<ReportFileProcessor>();
    private PlotterWrapperFactory<BmicPlotterWrapper> bmicPlotterWrapperFactory = new BmicPlotterWrapperFactory();
    private PlotterWrapperFactory<HdrPlotterWrapper> hdrPlotterWrapperFactory = new HdrPlotterWrapperFactory();
    private PlotterWrapperFactory<RatePlotterWrapper> ratePlotterWrapperFactory = new RatePlotterWrapperFactory();
    private String path;

    public ReportGenerator(String path) {
        this.path = path;
    }

    private void plotMptReportFile(ReportFile reportFile) {
        block4: {
            logger.debug("Will report file {} on thread {}", (Object)reportFile, (Object)Thread.currentThread().getId());
            try {
                if (reportFile instanceof MptReportFile) {
                    RatePlotterWrapper plotter = this.ratePlotterWrapperFactory.newPlotterWrapper();
                    plotter.plot(reportFile.getSourceFile());
                    break block4;
                }
                if (reportFile instanceof BmicReportFile) {
                    BmicPlotterWrapper plotter = this.bmicPlotterWrapperFactory.newPlotterWrapper();
                    plotter.plot(reportFile.getSourceFile());
                    break block4;
                }
                throw new Exception("Invalid report file for: " + reportFile.getSourceFile());
            }
            catch (Throwable t) {
                logger.error("Unable to plot file {}: {}", new Object[]{reportFile.getSourceFile(), t.getMessage(), t});
            }
        }
    }

    private void plotLatencyReportFile(ReportFile reportFile) {
        logger.debug("Will report file {} on thread {}", (Object)reportFile, (Object)Thread.currentThread().getId());
        try {
            if (!(reportFile instanceof HdrHistogramReportFile)) {
                throw new Exception("Invalid report file for: " + reportFile.getSourceFile());
            }
            logger.info("Plotting latency from {}", (Object)reportFile);
            HdrPlotterWrapper plotter = this.hdrPlotterWrapperFactory.newPlotterWrapper();
            plotter.plot(reportFile.getSourceFile());
        }
        catch (Throwable t) {
            logger.error("Unable to plot file {}: {}", new Object[]{reportFile.getSourceFile(), t.getMessage(), t});
        }
    }

    private void renderReportIndex(File baseDir, Map<String, Object> context) {
        IndexRenderer indexRenderer = new IndexRenderer(context);
        File outFile = new File(this.path, "index.html");
        try {
            FileUtils.writeStringToFile((File)outFile, (String)indexRenderer.render(), (Charset)Charsets.UTF_8);
            indexRenderer.copyResources(baseDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderNodePage(File baseDir, ReportDirInfo report) {
        logger.info("Processing report dir: {}", (Object)report.getReportDir());
        Map<String, Object> nodeReportContext = NodeContextBuilder.toContext(report, baseDir);
        NodeReportRenderer reportRenderer = new NodeReportRenderer(nodeReportContext);
        try {
            String outDir = this.path + report.getReportDir();
            File outFile = new File(outDir, "index.html");
            FileUtils.writeStringToFile((File)outFile, (String)reportRenderer.render(), (Charset)Charsets.UTF_8);
            reportRenderer.copyResources(outFile.getParentFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generate() {
        File baseDir = new File(this.path);
        logger.info("Building the file list to be processed by the report generator");
        ReportDirectoryWalker processor = new ReportDirectoryWalker(this.path);
        List<ReportFile> fileList = processor.generate(baseDir);
        logger.info("There are {} files to be processed", (Object)fileList.size());
        fileList.parallelStream().filter(item -> item.getSourceFile().getName().endsWith("csv.gz")).forEach(this::plotMptReportFile);
        fileList.stream().filter(item -> item.getSourceFile().getName().endsWith("hdr")).forEach(this::plotLatencyReportFile);
        this.preProcessors.stream().forEach(item -> item.process(fileList));
        Map<String, Object> context = ReportContextBuilder.toContext(fileList, baseDir);
        Set reports = (Set)context.get("reportDirs");
        reports.parallelStream().forEach(item -> this.renderNodePage(baseDir, (ReportDirInfo)item));
        this.renderReportIndex(baseDir, context);
        this.postProcessors.stream().forEach(item -> item.process(fileList));
    }

    public List<ReportFileProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public List<ReportFileProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setBmicPlotterWrapperFactory(PlotterWrapperFactory<BmicPlotterWrapper> bmicPlotterWrapperFactory) {
        this.bmicPlotterWrapperFactory = bmicPlotterWrapperFactory;
    }

    public void setHdrPlotterWrapperFactory(PlotterWrapperFactory<HdrPlotterWrapper> hdrPlotterWrapperFactory) {
        this.hdrPlotterWrapperFactory = hdrPlotterWrapperFactory;
    }

    public void setRatePlotterWrapperFactory(PlotterWrapperFactory<RatePlotterWrapper> ratePlotterWrapperFactory) {
        this.ratePlotterWrapperFactory = ratePlotterWrapperFactory;
    }

    @Deprecated
    public static void generate(String path) {
        ReportGenerator reportGenerator = new ReportGenerator(path);
        reportGenerator.generate();
    }
}

