/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.orpiske.mpt.reports.HdrHistogramReportFile;
import net.orpiske.mpt.reports.files.BmicReportFile;
import net.orpiske.mpt.reports.files.MptReportFile;
import net.orpiske.mpt.reports.files.ReportFile;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReportDirectoryWalker
extends DirectoryWalker {
    private static Logger logger = LoggerFactory.getLogger(ReportDirectoryWalker.class);
    private String initialPath;
    private List<ReportFile> files = new LinkedList<ReportFile>();

    public ReportDirectoryWalker(String initialPath) {
        this.initialPath = initialPath;
    }

    private void plotHdr(File file) {
        String normalizedName = file.getPath().replace(this.initialPath, "");
        this.files.add(new HdrHistogramReportFile(file, new File(normalizedName)));
    }

    private void plotRate(File file) {
        String normalizedName = file.getPath().replace(this.initialPath, "");
        this.files.add(new MptReportFile(file, new File(normalizedName)));
    }

    private void plotInspector(File file) {
        String normalizedName = file.getPath().replace(this.initialPath, "");
        this.files.add(new BmicReportFile(file, new File(normalizedName)));
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        logger.debug("Processing file {}", (Object)file.getPath());
        String ext = FilenameUtils.getExtension((String)file.getName());
        if ("hdr".equals(ext)) {
            this.plotHdr(file);
        }
        if ("gz".equals(ext)) {
            if (!file.getName().contains("inspector")) {
                this.plotRate(file);
            } else {
                this.plotInspector(file);
            }
        }
    }

    List<ReportFile> generate(File reportsDir) {
        if (logger.isDebugEnabled()) {
            logger.debug("Processing downloaded reports on {}", (Object)reportsDir.getName());
        }
        try {
            if (reportsDir.exists()) {
                this.walk(reportsDir, new ArrayList());
            } else {
                logger.error("The reports directory does not exist: {}", (Object)reportsDir.getPath());
            }
        }
        catch (IOException e) {
            logger.error("Unable to walk the whole directory: " + e.getMessage(), (Throwable)e);
            logger.error("Returning a partial list of all the reports due to errors");
        }
        return this.files;
    }
}

