/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import java.io.File;
import java.io.IOException;
import net.orpiske.mpt.common.test.TestProperties;
import org.apache.commons.io.FilenameUtils;

public class ReportDirInfo {
    private String reportDir;
    private String nodeType;
    private String nodeHost;
    private int testNum;
    private boolean testSuccessful = false;
    private TestProperties testProperties;

    public ReportDirInfo(String baseDir, String reportDir, String nodeType) throws IOException {
        this.reportDir = reportDir;
        this.nodeType = nodeType;
        File file = new File(reportDir);
        this.nodeHost = FilenameUtils.getBaseName((String)file.getName());
        File testNumDir = file.getParentFile();
        this.testNum = Integer.parseInt(FilenameUtils.getBaseName((String)testNumDir.getName()));
        File resultType = testNumDir.getParentFile();
        if (resultType.getName().contains("success")) {
            this.testSuccessful = true;
        }
        this.testProperties = new TestProperties();
        this.testProperties.load(new File(baseDir + File.separator + reportDir, "test.properties"));
    }

    public String getBrokerUri() {
        return this.testProperties.getBrokerUri();
    }

    public String getDurationType() {
        return this.testProperties.getDurationType();
    }

    public String getApiName() {
        return this.testProperties.getApiName();
    }

    public String getApiVersion() {
        return this.testProperties.getApiVersion();
    }

    public long getDuration() {
        return this.testProperties.getDuration();
    }

    public long getMessageSize() {
        return this.testProperties.getMessageSize();
    }

    public int getRate() {
        return this.testProperties.getRate();
    }

    public int getParallelCount() {
        return this.testProperties.getParallelCount();
    }

    public boolean isVariableSize() {
        return this.testProperties.isVariableSize();
    }

    public int getFcl() {
        return this.testProperties.getFcl();
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeHost() {
        return this.nodeHost;
    }

    public void setNodeHost(String nodeHost) {
        this.nodeHost = nodeHost;
    }

    public int getTestNum() {
        return this.testNum;
    }

    public void setTestNum(int testNum) {
        this.testNum = testNum;
    }

    public boolean isTestSuccessful() {
        return this.testSuccessful;
    }

    public void setTestSuccessful(boolean testSuccessful) {
        this.testSuccessful = testSuccessful;
    }

    public int hashCode() {
        return this.reportDir != null ? this.reportDir.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportDirInfo that = (ReportDirInfo)o;
        return this.reportDir != null ? this.reportDir.equals(that.reportDir) : that.reportDir == null;
    }
}

