/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.orpiske.mpt.reports.ReportDirInfo;
import net.orpiske.mpt.reports.files.ReportFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ReportContextBuilder.class);

    private ReportContextBuilder() {
    }

    public static Map<String, Object> toContext(List<ReportFile> reportFiles, File baseDir) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashSet<String> nodes = new HashSet<String>();
        HashSet<String> nodeTypes = new HashSet<String>();
        HashSet<Integer> tests = new HashSet<Integer>();
        LinkedHashSet<ReportDirInfo> reportDirs = new LinkedHashSet<ReportDirInfo>();
        for (ReportFile reportFile : reportFiles) {
            nodes.add(reportFile.getNodeHost());
            String nodeType = reportFile.getNodeType().getValue();
            nodeTypes.add(nodeType);
            tests.add(reportFile.getTestNum());
            try {
                ReportDirInfo reportDirInfo = new ReportDirInfo(baseDir.getPath(), reportFile.getReportDir(), nodeType);
                reportDirs.add(reportDirInfo);
            }
            catch (IOException e) {
                logger.error("Unable to add the directory information for {}: {}", (Object)baseDir.getPath(), (Object)e.getMessage());
                logger.error("Error: ", (Throwable)e);
            }
        }
        context.put("nodes", nodes);
        context.put("nodeTypes", nodeTypes);
        context.put("tests", tests);
        context.put("reportFiles", reportFiles);
        context.put("reportDirs", reportDirs);
        return context;
    }
}

