/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import java.io.File;
import net.orpiske.mpt.reports.files.ReportFile;
import org.apache.commons.io.FilenameUtils;

public class HdrHistogramReportFile
extends ReportFile {
    private File percentileImgAll;
    private File percentileImg90;
    private File percentileImg99;

    public HdrHistogramReportFile(File sourceFile, File normalizedFile) {
        super(sourceFile, normalizedFile);
        String basename = FilenameUtils.removeExtension((String)normalizedFile.getPath());
        this.percentileImgAll = new File(basename + "_all.png");
        this.percentileImg90 = new File(basename + "_90.png");
        this.percentileImg99 = new File(basename + "_99.png");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HdrHistogramReportFile that = (HdrHistogramReportFile)o;
        if (this.percentileImgAll != null ? !this.percentileImgAll.equals(that.percentileImgAll) : that.percentileImgAll != null) {
            return false;
        }
        if (this.percentileImg90 != null ? !this.percentileImg90.equals(that.percentileImg90) : that.percentileImg90 != null) {
            return false;
        }
        return this.percentileImg99 != null ? this.percentileImg99.equals(that.percentileImg99) : that.percentileImg99 == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.percentileImgAll != null ? this.percentileImgAll.hashCode() : 0);
        result = 31 * result + (this.percentileImg90 != null ? this.percentileImg90.hashCode() : 0);
        result = 31 * result + (this.percentileImg99 != null ? this.percentileImg99.hashCode() : 0);
        return result;
    }
}

