/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.reports;

import com.google.common.base.Charsets;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.loader.CascadingResourceLocator;
import com.hubspot.jinjava.loader.FileLocator;
import com.hubspot.jinjava.loader.ResourceLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.orpiske.mpt.common.Constants;
import net.orpiske.mpt.reports.custom.FileExists;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
    private Map<String, Object> context = new HashMap<String, Object>();

    public AbstractRenderer(Map<String, Object> context) {
        this.context = context;
    }

    protected String render(String name) throws Exception {
        JinjavaConfig config = new JinjavaConfig();
        Jinjava jinjava = null;
        jinjava = new Jinjava(config);
        jinjava.getGlobalContext().registerFilter((Filter)new FileExists());
        try {
            CascadingResourceLocator cr;
            File currentDir = new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
            FileLocator currentDirLocator = new FileLocator(currentDir);
            File templateDir = new File(Constants.HOME_DIR + File.separator + "templates");
            if (templateDir.exists()) {
                FileLocator installDirLocator = new FileLocator(templateDir);
                cr = new CascadingResourceLocator(new ResourceLocator[]{currentDirLocator, installDirLocator});
            } else {
                logger.warn("A template directory was not found, therefore ignoring");
                cr = new CascadingResourceLocator(new ResourceLocator[]{currentDirLocator});
            }
            jinjava.setResourceLocator((ResourceLocator)cr);
        }
        catch (FileNotFoundException e) {
            logger.warn("Unable to find the current working directory: " + e.getMessage(), (Throwable)e);
        }
        String text = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(name), (Charset)Charsets.UTF_8);
        return jinjava.render(text, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResources(File path, String resource, String outName) throws IOException {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        File outputFile = new File(path, outName);
        if (outputFile.exists()) {
            return;
        }
        try {
            inputStream = this.getClass().getResourceAsStream(resource);
            outputStream = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public abstract String render() throws Exception;
}

