/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.utils.contrib.net;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class URLUtils {
    public static final String URL_SEPARATOR = "/";
    private static final String PARAMETERS_START = "?";

    private URLUtils() {
    }

    public static String removeParametersFromName(String filename) {
        if (!filename.contains(PARAMETERS_START)) {
            return filename;
        }
        int firstParameter = filename.indexOf(PARAMETERS_START);
        return filename.substring(0, firstParameter);
    }

    public static String getFilename(URI uri) throws MalformedURLException {
        if (uri == null) {
            throw new MalformedURLException("The input URL 'null' is not valid");
        }
        URL url = uri.toURL();
        String filePath = url.getFile();
        int lastIndex = filePath.lastIndexOf(URL_SEPARATOR);
        String filenameWithParameters = filePath.substring(lastIndex + 1);
        return URLUtils.removeParametersFromName(filenameWithParameters);
    }

    public static String getFilename(String uri) throws MalformedURLException, URISyntaxException {
        return URLUtils.getFilename(new URI(uri));
    }
}

