/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.notes;

import java.io.IOException;
import net.orpiske.mpt.maestro.notes.MaestroCommand;
import net.orpiske.mpt.maestro.notes.MaestroEventListener;
import net.orpiske.mpt.maestro.notes.MaestroRequest;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageUnpacker;

public class SetRequest
extends MaestroRequest {
    private Option option;
    private String value;

    public SetRequest() {
        super(MaestroCommand.MAESTRO_NOTE_SET);
    }

    public SetRequest(MessageUnpacker unpacker) throws IOException {
        super(MaestroCommand.MAESTRO_NOTE_SET);
        this.option = Option.from(unpacker.unpackLong());
        this.value = unpacker.unpackString();
    }

    private void set(Option option, String value) {
        this.option = option;
        this.value = value;
    }

    public void setBroker(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_BROKER, value);
    }

    public void setDurationType(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_DURATION_TYPE, value);
    }

    public void setLogLevel(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_LOG_LEVEL, value);
    }

    public void setParallelCount(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_PARALLEL_COUNT, value);
    }

    public void setMessageSize(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_MESSAGE_SIZE, value);
    }

    public void setThrottle(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_THROTTLE, value);
    }

    public void setRate(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_SET_RATE, value);
    }

    public void setFCL(String value) {
        this.set(Option.MAESTRO_NOTE_OPT_FCL, value);
    }

    public Option getOption() {
        return this.option;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    protected MessageBufferPacker pack() throws IOException {
        MessageBufferPacker packer = super.pack();
        packer.packLong(this.option.getValue());
        packer.packString(this.value);
        return packer;
    }

    @Override
    public void notify(MaestroEventListener visitor) {
        visitor.handle(this);
    }

    @Override
    public String toString() {
        return "SetRequest{option=" + (Object)((Object)this.option) + ", value='" + this.value + '\'' + "} " + super.toString();
    }

    public static enum Option {
        MAESTRO_NOTE_OPT_SET_BROKER(0L),
        MAESTRO_NOTE_OPT_SET_DURATION_TYPE(1L),
        MAESTRO_NOTE_OPT_SET_LOG_LEVEL(2L),
        MAESTRO_NOTE_OPT_SET_PARALLEL_COUNT(3L),
        MAESTRO_NOTE_OPT_SET_MESSAGE_SIZE(4L),
        MAESTRO_NOTE_OPT_SET_THROTTLE(5L),
        MAESTRO_NOTE_OPT_SET_RATE(6L),
        MAESTRO_NOTE_OPT_FCL(7L);

        private long value;

        private Option(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public static Option from(long value) {
            switch ((int)value) {
                case 0: {
                    return MAESTRO_NOTE_OPT_SET_BROKER;
                }
                case 1: {
                    return MAESTRO_NOTE_OPT_SET_DURATION_TYPE;
                }
                case 2: {
                    return MAESTRO_NOTE_OPT_SET_LOG_LEVEL;
                }
                case 3: {
                    return MAESTRO_NOTE_OPT_SET_PARALLEL_COUNT;
                }
                case 4: {
                    return MAESTRO_NOTE_OPT_SET_MESSAGE_SIZE;
                }
                case 5: {
                    return MAESTRO_NOTE_OPT_SET_THROTTLE;
                }
                case 6: {
                    return MAESTRO_NOTE_OPT_SET_RATE;
                }
                case 7: {
                    return MAESTRO_NOTE_OPT_FCL;
                }
            }
            return null;
        }
    }
}

