/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.maestro.client.AbstractMaestroPeer;
import net.orpiske.mpt.maestro.client.MaestroDeserializer;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroCollector
extends AbstractMaestroPeer<MaestroNote> {
    private static final Logger logger = LoggerFactory.getLogger(MaestroCollector.class);
    private boolean running = true;
    private List<MaestroNote> collected = Collections.synchronizedList(new LinkedList());

    public MaestroCollector(String url) throws MaestroConnectionException {
        super(url, "maestro-java-collector", MaestroDeserializer::deserialize);
    }

    @Override
    protected void noteArrived(MaestroNote note) {
        this.collected.add(note);
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public synchronized List<MaestroNote> collect() {
        LinkedList<MaestroNote> ret = new LinkedList<MaestroNote>(this.collected);
        this.collected.clear();
        return ret;
    }
}

