/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro;

import java.util.concurrent.TimeUnit;
import net.orpiske.mpt.common.client.MaestroReceiver;
import net.orpiske.mpt.common.duration.EpochClocks;
import net.orpiske.mpt.common.duration.EpochMicroClock;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.maestro.client.MaestroClient;
import net.orpiske.mpt.maestro.notes.InternalError;
import net.orpiske.mpt.maestro.notes.OkResponse;
import net.orpiske.mpt.maestro.notes.PingResponse;
import net.orpiske.mpt.maestro.notes.TestFailedNotification;
import net.orpiske.mpt.maestro.notes.TestSuccessfulNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaestroReceiverClient
extends MaestroClient
implements MaestroReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MaestroReceiverClient.class);
    private final EpochMicroClock epochMicroClock;
    private String clientName;
    private String host;
    private String id;

    public MaestroReceiverClient(String url, String clientName, String host, String id) throws MaestroException {
        super(url);
        this.clientName = clientName;
        this.host = host;
        this.id = id;
        this.epochMicroClock = EpochClocks.exclusiveMicro();
    }

    public void replyOk() {
        logger.trace("Sending the OK response from {}", (Object)this.toString());
        OkResponse okResponse = new OkResponse();
        okResponse.setName(this.clientName + "@" + this.host);
        okResponse.setId(this.id);
        try {
            super.publish("/mpt/maestro", okResponse);
        }
        catch (Exception e) {
            logger.error("Unable to publish the OK response {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void replyInternalError() {
        logger.trace("Sending the internal error response from {}", (Object)this.toString());
        InternalError errResponse = new InternalError();
        errResponse.setName(this.clientName + "@" + this.host);
        errResponse.setId(this.id);
        try {
            super.publish("/mpt/maestro", errResponse);
        }
        catch (Exception e) {
            logger.error("Unable to publish the OK response: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void pingResponse(long sec, long uSec) {
        logger.trace("Creation seconds.micro: {}.{}", (Object)sec, (Object)uSec);
        long creationEpochMicros = TimeUnit.SECONDS.toMicros(sec) + uSec;
        long nowMicros = this.epochMicroClock.microTime();
        long elapsedMicros = nowMicros - creationEpochMicros;
        logger.trace("Elapsed: {}", (Object)elapsedMicros);
        PingResponse response = new PingResponse();
        response.setElapsed(TimeUnit.MICROSECONDS.toMillis(elapsedMicros));
        response.setName(this.clientName + "@" + this.host);
        response.setId(this.id);
        super.publish("/mpt/maestro", response);
    }

    public void notifySuccess(String message) {
        logger.trace("Sending the test success notification from {}", (Object)this.toString());
        TestSuccessfulNotification notification = new TestSuccessfulNotification();
        notification.setName(this.clientName + "@" + this.host);
        notification.setId(this.id);
        notification.setMessage(message);
        try {
            super.publish("/mpt/notifications", notification, 0, true);
        }
        catch (Exception e) {
            logger.error("Unable to publish the success notification: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void notifyFailure(String message) {
        logger.trace("Sending the test success notification from {}", (Object)this.toString());
        TestFailedNotification notification = new TestFailedNotification();
        notification.setName(this.clientName + "@" + this.host);
        notification.setId(this.id);
        notification.setMessage(message);
        try {
            super.publish("/mpt/notifications", notification, 0, true);
        }
        catch (Exception e) {
            logger.error("Unable to publish the failure notification: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void abnormalDisconnect() {
    }
}

