/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.mpt.maestro;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.orpiske.mpt.common.client.MaestroRequester;
import net.orpiske.mpt.common.exceptions.MaestroConnectionException;
import net.orpiske.mpt.common.exceptions.MaestroException;
import net.orpiske.mpt.maestro.client.MaestroClient;
import net.orpiske.mpt.maestro.client.MaestroCollectorExecutor;
import net.orpiske.mpt.maestro.notes.FlushRequest;
import net.orpiske.mpt.maestro.notes.Halt;
import net.orpiske.mpt.maestro.notes.MaestroNote;
import net.orpiske.mpt.maestro.notes.PingRequest;
import net.orpiske.mpt.maestro.notes.SetRequest;
import net.orpiske.mpt.maestro.notes.StartInspector;
import net.orpiske.mpt.maestro.notes.StartReceiver;
import net.orpiske.mpt.maestro.notes.StartSender;
import net.orpiske.mpt.maestro.notes.StatsRequest;
import net.orpiske.mpt.maestro.notes.StopInspector;
import net.orpiske.mpt.maestro.notes.StopReceiver;
import net.orpiske.mpt.maestro.notes.StopSender;

public final class Maestro
implements MaestroRequester {
    private MaestroClient maestroClient = null;
    private MaestroCollectorExecutor collectorExecutor;
    private Thread collectorThread;

    public Maestro(String url) throws MaestroException {
        this.collectorExecutor = new MaestroCollectorExecutor(url);
        this.maestroClient = new MaestroClient(url);
        this.maestroClient.connect();
        this.collectorThread = new Thread(this.collectorExecutor);
        this.collectorThread.start();
    }

    public void stop() throws MaestroConnectionException {
        this.maestroClient.disconnect();
        this.collectorExecutor.stop();
        try {
            this.collectorThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void flushRequest() throws MaestroConnectionException, IOException {
        this.flushRequest("/mpt/daemon");
    }

    public void flushRequest(String topic) throws MaestroConnectionException, IOException {
        FlushRequest maestroNote = new FlushRequest();
        this.maestroClient.publish(topic, maestroNote);
    }

    public void pingRequest() throws MaestroConnectionException, IOException {
        this.pingRequest("/mpt/daemon");
    }

    public void pingRequest(String topic) throws MaestroConnectionException, IOException {
        PingRequest maestroNote = new PingRequest();
        this.maestroClient.publish(topic, maestroNote);
    }

    public void setBroker(String value) throws MaestroConnectionException, IOException {
        this.setBroker("/mpt/daemon", value);
    }

    public void setBroker(String topic, String value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setBroker(value);
        this.maestroClient.publish(topic, maestroNote);
    }

    public void setDuration(Object value) throws IOException, MaestroException {
        this.setDuration("/mpt/daemon", value);
    }

    public void setDuration(String topic, Object value) throws IOException, MaestroException {
        SetRequest maestroNote = new SetRequest();
        if (value instanceof String) {
            maestroNote.setDurationType((String)value);
        } else if (Long.class.isInstance(value)) {
            maestroNote.setDurationType(Long.toString((Long)value));
        } else {
            throw new MaestroException("Invalid duration type class " + value.getClass());
        }
        this.maestroClient.publish(topic, maestroNote);
    }

    public void setLogLevel(String value) throws MaestroConnectionException, IOException {
        this.setLogLevel("/mpt/daemon", value);
    }

    public void setLogLevel(String topic, String value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setLogLevel(value);
        this.maestroClient.publish(topic, maestroNote);
    }

    public void setParallelCount(int value) throws MaestroConnectionException, IOException {
        this.setParallelCount("/mpt/daemon", value);
    }

    public void setParallelCount(String topic, int value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setParallelCount(Integer.toString(value));
        this.maestroClient.publish(topic, maestroNote);
    }

    public void setMessageSize(String value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setMessageSize(value);
        this.maestroClient.publish("/mpt/daemon", maestroNote);
    }

    public void setMessageSize(long value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setMessageSize(Long.toString(value));
        this.maestroClient.publish("/mpt/daemon", maestroNote);
    }

    public void setThrottle(int value) throws MaestroConnectionException, IOException {
        this.setThrottle("/mpt/daemon", value);
    }

    public void setThrottle(String topic, int value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setThrottle(Integer.toString(value));
        this.maestroClient.publish(topic, maestroNote);
    }

    public void setRate(int value) throws MaestroConnectionException, IOException {
        this.setRate("/mpt/daemon", value);
    }

    public void setRate(String topic, int value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setRate(Integer.toString(value));
        this.maestroClient.publish("/mpt/daemon", maestroNote);
    }

    public void setFCL(int value) throws MaestroConnectionException, IOException {
        SetRequest maestroNote = new SetRequest();
        maestroNote.setFCL(Integer.toString(value));
        this.maestroClient.publish("/mpt/daemon", maestroNote);
    }

    public void startInspector() throws MaestroConnectionException, IOException {
        StartInspector maestroNote = new StartInspector();
        this.maestroClient.publish("/mpt/daemon/brokerd", maestroNote);
    }

    public void stopInspector() throws MaestroConnectionException, IOException {
        StopInspector maestroNote = new StopInspector();
        this.maestroClient.publish("/mpt/daemon/brokerd", maestroNote);
    }

    public void startSender() throws MaestroConnectionException, IOException {
        StartSender maestroNote = new StartSender();
        this.maestroClient.publish("/mpt/daemon/sender", maestroNote);
    }

    public void stopSender() throws MaestroConnectionException, IOException {
        StopSender maestroNote = new StopSender();
        this.maestroClient.publish("/mpt/daemon/sender", maestroNote);
    }

    public void startReceiver() throws MaestroConnectionException, IOException {
        StartReceiver maestroNote = new StartReceiver();
        this.maestroClient.publish("/mpt/daemon/receiver", maestroNote);
    }

    public void stopReceiver() throws MaestroConnectionException, IOException {
        StopReceiver maestroNote = new StopReceiver();
        this.maestroClient.publish("/mpt/daemon/receiver", maestroNote);
    }

    public void statsRequest() throws MaestroConnectionException, IOException {
        StatsRequest maestroNote = new StatsRequest();
        this.maestroClient.publish("/mpt/daemon", maestroNote);
    }

    public void halt() throws MaestroConnectionException, IOException {
        Halt maestroNote = new Halt();
        this.maestroClient.publish("/mpt/daemon", maestroNote);
    }

    public List<MaestroNote> collect() {
        return this.collectorExecutor.collect();
    }

    private boolean hasReplies(List<?> replies) {
        return replies != null && replies.size() > 0;
    }

    public List<MaestroNote> collect(long wait, int retries) {
        List<MaestroNote> replies = null;
        while (!this.hasReplies(replies = this.collectorExecutor.collect())) {
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (--retries > 0) continue;
        }
        return replies;
    }

    public List<MaestroNote> collect(long wait, int retries, int expect) {
        LinkedList<MaestroNote> replies = new LinkedList<MaestroNote>();
        do {
            List<MaestroNote> collected;
            if ((collected = this.collectorExecutor.collect()) != null) {
                replies.addAll(collected);
                if (this.hasReplies(replies) && replies.size() >= expect) break;
            }
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (--retries > 0);
        return replies;
    }
}

