/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.bmic.plot;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import net.orpiske.bmic.plot.BmicData;
import net.orpiske.bmic.plot.BmicRecord;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmicReader {
    private static final Logger logger = LoggerFactory.getLogger(BmicReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BmicData read(String filename) throws IOException {
        BmicData bmicData;
        FileInputStream fileStream = null;
        GZIPInputStream gzipStream = null;
        InputStreamReader in = null;
        logger.debug("Reading file {}", (Object)filename);
        try {
            fileStream = new FileInputStream(filename);
            gzipStream = new GZIPInputStream(fileStream);
            in = new InputStreamReader(gzipStream);
            CSVParser records = CSVFormat.RFC4180.withCommentMarker('#').withFirstRecordAsHeader().withRecordSeparator(';').withQuote('\"').withQuoteMode(QuoteMode.NON_NUMERIC).parse((Reader)in);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            BmicData bmicData2 = new BmicData();
            for (CSVRecord record : records) {
                Date timeStamp = null;
                try {
                    timeStamp = formatter.parse(record.get(0));
                    BmicRecord bmicRecord = new BmicRecord();
                    bmicRecord.setTimestamp(timeStamp);
                    bmicRecord.setLoadValue(Double.parseDouble(record.get(1)));
                    bmicRecord.setOpenFds(Integer.parseInt(record.get(2)));
                    bmicRecord.setFreeFds(Integer.parseInt(record.get(3)));
                    bmicRecord.setFreeMem(Integer.parseInt(record.get(4)));
                    bmicRecord.setSwapFree(Integer.parseInt(record.get(5)));
                    bmicRecord.setSwapCommitted(Integer.parseInt(record.get(6)));
                    bmicRecord.setEdenInitial(Integer.parseInt(record.get(7)));
                    bmicRecord.setEdenCommitted(Integer.parseInt(record.get(8)));
                    bmicRecord.setEdenMax(Integer.parseInt(record.get(9)));
                    bmicRecord.setEdenUsed(Integer.parseInt(record.get(10)));
                    bmicRecord.setSurvivorInitial(Integer.parseInt(record.get(11)));
                    bmicRecord.setSurvivorCommitted(Integer.parseInt(record.get(12)));
                    bmicRecord.setSurvivorMax(Integer.parseInt(record.get(13)));
                    bmicRecord.setSurvivorUsed(Integer.parseInt(record.get(14)));
                    bmicRecord.setTenuredInitial(Integer.parseInt(record.get(15)));
                    bmicRecord.setTenuredCommitted(Integer.parseInt(record.get(16)));
                    bmicRecord.setTenuredMax(Integer.parseInt(record.get(17)));
                    bmicRecord.setTenuredUsed(Integer.parseInt(record.get(18)));
                    bmicRecord.setPmInitial(Integer.parseInt(record.get(19)));
                    bmicRecord.setPmCommitted(Integer.parseInt(record.get(20)));
                    bmicRecord.setPmMax(Long.parseLong(record.get(21)));
                    bmicRecord.setPmUsed(Integer.parseInt(record.get(22)));
                    bmicRecord.setQueueSize(Integer.parseInt(record.get(23)));
                    bmicRecord.setConsumer(Integer.parseInt(record.get(23)));
                    bmicRecord.setAck(Integer.parseInt(record.get(25)));
                    bmicRecord.setExp(Integer.parseInt(record.get(26)));
                    bmicData2.add(bmicRecord);
                }
                catch (Throwable t) {
                    logger.warn("Unable to parse record: {}", (Object)t.getMessage(), (Object)t);
                }
            }
            bmicData = bmicData2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(gzipStream);
            IOUtils.closeQuietly(fileStream);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(gzipStream);
        IOUtils.closeQuietly(fileStream);
        return bmicData;
    }
}

