/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.bmic.plot;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import net.orpiske.bmic.plot.BmicData;
import net.orpiske.bmic.plot.exceptions.BmicEmptyDataSet;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.colors.XChartSeriesColors;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class BmicPlotter {
    private String baseName;
    private int outputWidth = 1200;
    private int outputHeight = 700;
    private boolean plotGridLinesVisible = true;

    public BmicPlotter(String baseName) {
        this.baseName = baseName;
    }

    private void validateDataSet(List<?> xData, List<?> yData) throws BmicEmptyDataSet {
        if (xData == null || xData.size() == 0) {
            throw new BmicEmptyDataSet("The 'X' column data set is empty");
        }
        if (yData == null || yData.size() == 0) {
            throw new BmicEmptyDataSet("The 'Y' column data set is empty");
        }
    }

    private XYChart buildCommonChart(String title, String yTitle) {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(this.outputWidth)).height(this.outputHeight)).title(title)).xAxisTitle("Time").yAxisTitle(yTitle).build();
        ((XYStyler)chart.getStyler()).setPlotBackgroundColor(ChartColor.getAWTColor((ChartColor)ChartColor.WHITE));
        ((XYStyler)chart.getStyler()).setChartBackgroundColor(Color.WHITE);
        ((XYStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(new Color(0, 222, 0));
        ((XYStyler)chart.getStyler()).setPlotGridLinesVisible(this.plotGridLinesVisible);
        ((XYStyler)chart.getStyler()).setYAxisTickMarkSpacingHint(15);
        ((XYStyler)chart.getStyler()).setXAxisLabelRotation(45);
        ((XYStyler)chart.getStyler()).setAxisTickMarkLength(15);
        ((XYStyler)chart.getStyler()).setPlotMargin(0);
        ((XYStyler)chart.getStyler()).setPlotContentSize(0.95);
        ((XYStyler)chart.getStyler()).setDatePattern("yyyy-MM-dd HH:mm:ss");
        ((XYStyler)chart.getStyler()).setChartTitleFont(new Font("Verdana", 1, 14));
        ((XYStyler)chart.getStyler()).setLegendFont(new Font("Verdana", 0, 12));
        ((XYStyler)chart.getStyler()).setAxisTitleFont(new Font("Verdana", 0, 12));
        ((XYStyler)chart.getStyler()).setAxisTickLabelsFont(new Font("Verdana", 0, 10));
        return chart;
    }

    private void plotQueueData(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("Queue Size", "Number of messages");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getQueueSizes());
        XYSeries queueSeries = chart.addSeries("Queue Size", bmicData.getTimestamps(), bmicData.getQueueSizes());
        queueSeries.setLineColor(XChartSeriesColors.BLUE);
        queueSeries.setMarkerColor(Color.LIGHT_GRAY);
        queueSeries.setMarker(SeriesMarkers.DIAMOND);
        queueSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getExp());
        XYSeries expSeries = chart.addSeries("Expired Messages", bmicData.getTimestamps(), bmicData.getExp());
        expSeries.setLineColor(XChartSeriesColors.GREEN);
        expSeries.setMarkerColor(Color.LIGHT_GRAY);
        expSeries.setMarker(SeriesMarkers.NONE);
        expSeries.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_queue_data.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotEdenMemory(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("Eden Memory", "Memory (Megabytes)");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getEdenUsed());
        XYSeries edenUsedSeries = chart.addSeries("Eden Used", bmicData.getTimestamps(), bmicData.getEdenUsed());
        edenUsedSeries.setLineColor(XChartSeriesColors.BLUE);
        edenUsedSeries.setMarkerColor(Color.LIGHT_GRAY);
        edenUsedSeries.setMarker(SeriesMarkers.NONE);
        edenUsedSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getEdenCommitted());
        XYSeries edenCommitted = chart.addSeries("Eden Committed", bmicData.getTimestamps(), bmicData.getEdenCommitted());
        edenCommitted.setLineColor(XChartSeriesColors.GREEN);
        edenCommitted.setMarkerColor(Color.LIGHT_GRAY);
        edenCommitted.setMarker(SeriesMarkers.NONE);
        edenCommitted.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_eden_memory.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotOSMemory(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("OS Memory", "Memory (Megabytes)");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getFreeMems());
        XYSeries edenUsedSeries = chart.addSeries("Free Memory", bmicData.getTimestamps(), bmicData.getFreeMems());
        edenUsedSeries.setLineColor(XChartSeriesColors.BLUE);
        edenUsedSeries.setMarkerColor(Color.LIGHT_GRAY);
        edenUsedSeries.setMarker(SeriesMarkers.NONE);
        edenUsedSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getSwapFrees());
        XYSeries edenCommitted = chart.addSeries("Free Swap", bmicData.getTimestamps(), bmicData.getSwapFrees());
        edenCommitted.setLineColor(XChartSeriesColors.GREEN);
        edenCommitted.setMarkerColor(Color.LIGHT_GRAY);
        edenCommitted.setMarker(SeriesMarkers.NONE);
        edenCommitted.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_memory.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotSurvivorMemory(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("Survivor Memory", "Memory (Megabytes)");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getSurvivorUsed());
        XYSeries edenUsedSeries = chart.addSeries("Survivor Used", bmicData.getTimestamps(), bmicData.getSurvivorUsed());
        edenUsedSeries.setLineColor(XChartSeriesColors.BLUE);
        edenUsedSeries.setMarkerColor(Color.LIGHT_GRAY);
        edenUsedSeries.setMarker(SeriesMarkers.NONE);
        edenUsedSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getSurvivorCommitted());
        XYSeries edenCommitted = chart.addSeries("Survivor Committed", bmicData.getTimestamps(), bmicData.getSurvivorCommitted());
        edenCommitted.setLineColor(XChartSeriesColors.GREEN);
        edenCommitted.setMarkerColor(Color.LIGHT_GRAY);
        edenCommitted.setMarker(SeriesMarkers.NONE);
        edenCommitted.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_survivor_memory.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotTenuredMemory(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("Tenured Memory", "Memory (Megabytes)");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getTenuredUsed());
        XYSeries edenUsedSeries = chart.addSeries("Tenured Used", bmicData.getTimestamps(), bmicData.getTenuredUsed());
        edenUsedSeries.setLineColor(XChartSeriesColors.BLUE);
        edenUsedSeries.setMarkerColor(Color.LIGHT_GRAY);
        edenUsedSeries.setMarker(SeriesMarkers.NONE);
        edenUsedSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getTenuredCommitted());
        XYSeries edenCommitted = chart.addSeries("Tenured Committed", bmicData.getTimestamps(), bmicData.getTenuredCommitted());
        edenCommitted.setLineColor(XChartSeriesColors.GREEN);
        edenCommitted.setMarkerColor(Color.LIGHT_GRAY);
        edenCommitted.setMarker(SeriesMarkers.NONE);
        edenCommitted.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_tenured_memory.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotPMMemory(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("PermGen/Metaspace Memory", "Memory (Megabytes)");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getPmUsed());
        XYSeries edenUsedSeries = chart.addSeries("PermGen/Metaspace Used", bmicData.getTimestamps(), bmicData.getPmUsed());
        edenUsedSeries.setLineColor(XChartSeriesColors.BLUE);
        edenUsedSeries.setMarkerColor(Color.LIGHT_GRAY);
        edenUsedSeries.setMarker(SeriesMarkers.NONE);
        edenUsedSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getPmCommitted());
        XYSeries edenCommitted = chart.addSeries("PermGen/Metaspace Committed", bmicData.getTimestamps(), bmicData.getPmCommitted());
        edenCommitted.setLineColor(XChartSeriesColors.GREEN);
        edenCommitted.setMarkerColor(Color.LIGHT_GRAY);
        edenCommitted.setMarker(SeriesMarkers.NONE);
        edenCommitted.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_pm_memory.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    private void plotFileDescriptor(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        XYChart chart = this.buildCommonChart("File Descriptors", "Count");
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getOpenFds());
        XYSeries edenUsedSeries = chart.addSeries("Open File Descriptors", bmicData.getTimestamps(), bmicData.getOpenFds());
        edenUsedSeries.setLineColor(XChartSeriesColors.BLUE);
        edenUsedSeries.setMarkerColor(Color.LIGHT_GRAY);
        edenUsedSeries.setMarker(SeriesMarkers.NONE);
        edenUsedSeries.setLineStyle(SeriesLines.SOLID);
        this.validateDataSet(bmicData.getTimestamps(), bmicData.getFreeFds());
        XYSeries edenCommitted = chart.addSeries("Free File Descriptors", bmicData.getTimestamps(), bmicData.getFreeFds());
        edenCommitted.setLineColor(XChartSeriesColors.GREEN);
        edenCommitted.setMarkerColor(Color.LIGHT_GRAY);
        edenCommitted.setMarker(SeriesMarkers.NONE);
        edenCommitted.setLineStyle(SeriesLines.SOLID);
        BitmapEncoder.saveBitmap((Chart)chart, (String)(this.baseName + "_descriptors.png"), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    public void plot(BmicData bmicData) throws IOException, BmicEmptyDataSet {
        this.plotQueueData(bmicData);
        this.plotOSMemory(bmicData);
        this.plotEdenMemory(bmicData);
        this.plotSurvivorMemory(bmicData);
        this.plotTenuredMemory(bmicData);
        this.plotPMMemory(bmicData);
    }

    public void setOutputWidth(int outputWidth) {
        this.outputWidth = outputWidth;
    }

    public void setOutputHeight(int outputHeight) {
        this.outputHeight = outputHeight;
    }

    public void setPlotGridLinesVisible(boolean plotGridLinesVisible) {
        this.plotGridLinesVisible = plotGridLinesVisible;
    }
}

