/*
 * Decompiled with CFR 0.152.
 */
package net.orpiske.bmic.main;

import java.util.Date;
import net.orpiske.bmic.plot.BmicData;
import net.orpiske.bmic.plot.BmicPlotter;
import net.orpiske.bmic.plot.BmicReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static CommandLine cmdLine;
    private static String fileName;

    private static void help(Options options, int code) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("bmic-data-plotter", options);
        System.exit(code);
    }

    private static void processCommand(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "prints the help");
        options.addOption("f", "file", true, "file to plot");
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            Main.help(options, -1);
        }
        if (cmdLine.hasOption("help")) {
            Main.help(options, 0);
        }
        if ((fileName = cmdLine.getOptionValue('f')) == null) {
            Main.help(options, -1);
        }
    }

    public static void main(String[] args) {
        Main.processCommand(args);
        try {
            BmicReader bmicReader = new BmicReader();
            BmicData bmicData = bmicReader.read(fileName);
            String baseName = FilenameUtils.removeExtension(fileName);
            baseName = FilenameUtils.removeExtension(baseName);
            BmicPlotter plotter = new BmicPlotter(baseName);
            logger.debug("Number of records to plot: {} ", (Object)bmicData.getTimestamps().size());
            for (Date d : bmicData.getTimestamps()) {
                logger.debug("Adding date record for plotting: {}", (Object)d);
            }
            plotter.plot(bmicData);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        System.exit(1);
    }
}

