/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.wrapper;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Booter {
    private static final String MAIN_CLASS_NAME = "dev.jeka.core.tool.Main";
    private static final String JK_USER_HOM_ENV_NAME = "JEKA_USER_HOME";
    private static final String BIN_NAME = "dev.jeka.jeka-core.jar";
    private static final String JK_CACHE_ENV_NAME = "JEKA_CACHE_DIR";
    public static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2";
    public static final String GITHUB_PACKAGE_URL = "https://maven.pkg.github.com/jeka-dev/jeka";

    public static void main(String[] args) throws Exception {
        Path jekawDir = Paths.get(args[0], new String[0]);
        Properties props = Booter.props(jekawDir);
        props.putAll((Map<?, ?>)Booter.props(args));
        Path jekaBinPath = Booter.location(props);
        if (jekaBinPath == null) {
            String version = Booter.version(props);
            jekaBinPath = Booter.getJekaBinPath(version);
            if (!Files.exists(jekaBinPath, new LinkOption[0])) {
                String baseUrl = props.getProperty("jeka.distrib.repo", Booter.repoOptions());
                if (baseUrl == null) {
                    baseUrl = MAVEN_CENTRAL_URL;
                }
                Path dir = Booter.install(baseUrl, version);
                Files.deleteIfExists(dir.resolve("global.properties"));
                Files.deleteIfExists(dir.resolve("jeka.bat"));
                Files.deleteIfExists(dir.resolve("jeka"));
                System.out.println("Jeka " + version + " installed in " + dir);
            }
        } else if (!Files.exists(jekaBinPath, new LinkOption[0])) {
            System.out.println("File " + jekaBinPath + " mentioned in property file not found");
            System.exit(1);
        }
        LinkedList<URL> classpath = new LinkedList<URL>();
        classpath.addAll(Booter.getBootLibs());
        classpath.add(jekaBinPath.toUri().toURL());
        URLClassLoader classLoader = new URLClassLoader(classpath.toArray(new URL[0]));
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> mainClass = classLoader.loadClass(MAIN_CLASS_NAME);
        Method method = mainClass.getMethod("main", String[].class);
        String[] actualArgs = args.length <= 1 ? new String[]{} : Arrays.copyOfRange(args, 1, args.length);
        method.invoke(null, new Object[]{actualArgs});
    }

    public static Path install(String baseUrl, String version) {
        Path zip = Booter.downloadDistribZip(baseUrl, version);
        Path dir = Booter.getJekaVersionCacheDir(version);
        System.out.println("Unzip distribution to " + dir + " ...");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Booter.unzip(zip, dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<URL> getBootLibs() {
        Path bootDir = Paths.get("jeka/boot", new String[0]);
        if (!Files.exists(bootDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.list(bootDir);){
            List<URL> list = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".jar")).map(path -> {
                try {
                    return path.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path downloadDistribZip(String baseUrl, String version) {
        String base = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        String downloadUrl = base + "dev/jeka/jeka-core/" + version + "/jeka-core-" + version + "-distrib.zip";
        System.out.println("Downloading " + downloadUrl + " ...");
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(Booter.openStream(downloadUrl));){
            Path temp = Files.createTempFile("jeka-wrapper", ".zip", new FileAttribute[0]);
            try (FileOutputStream fileOutputStream = new FileOutputStream(temp.toFile());){
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            Path path = temp;
            return path;
        }
        catch (FileNotFoundException e) {
            System.out.println(downloadUrl + " not found. Please check that version " + version + " exists in repo " + baseUrl);
            System.out.println("Jeka version to download is defined in ./jeka/wrapper/wrapper.properties file.");
            System.exit(1);
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void unzip(Path zip, Path dir) throws IOException {
        try (InputStream fis = Files.newInputStream(zip, new OpenOption[0]);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                Path file = dir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
                        Files.delete(file);
                    }
                    if (!Files.exists(file, new LinkOption[0])) {
                        Files.createDirectories(file, new FileAttribute[0]);
                    }
                } else {
                    Path parent = file.getParent();
                    if (!Files.exists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    if (Files.exists(file, new LinkOption[0])) {
                        Files.delete(file);
                    }
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file.toFile()));){
                        int location;
                        byte[] buffer = new byte[Math.toIntExact(entry.getSize())];
                        while ((location = zis.read(buffer)) != -1) {
                            bos.write(buffer, 0, location);
                        }
                    }
                }
                entry = zis.getNextEntry();
            }
        }
    }

    private static Path getCacheDir() {
        String env = System.getenv(JK_CACHE_ENV_NAME);
        Path result = env != null && !env.trim().isEmpty() ? Paths.get(env, new String[0]) : Booter.getJekaUserHomeDir().resolve("cache");
        return result;
    }

    private static Path getJekaUserHomeDir() {
        String env = System.getenv(JK_USER_HOM_ENV_NAME);
        Path result = env != null && !env.trim().isEmpty() ? Paths.get(env, new String[0]) : Paths.get(System.getProperty("user.home"), new String[0]).resolve(".jeka");
        if (Files.exists(result, new LinkOption[0]) && Files.isRegularFile(result, new LinkOption[0])) {
            try {
                Files.delete(result);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            Files.createDirectories(result, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result;
    }

    private static Path getJekaVersionCacheDir(String version) {
        Path result = Booter.getCacheDir().resolve("distributions/" + version);
        try {
            Files.createDirectories(result, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return result;
    }

    private static Path getJekaBinPath(String version) {
        return Booter.getJekaVersionCacheDir(version).resolve(BIN_NAME);
    }

    private static Path getWrapperPropsFile(Path jekawDir) {
        return jekawDir.resolve("jeka/wrapper/wrapper.properties");
    }

    private static String version(Properties props) {
        String result = props.getProperty("jeka.version");
        if (result == null || result.trim().isEmpty()) {
            System.out.println("Please, specify a jeka.version property in file ./jeka/wrapper/wrapper.properties");
            System.exit(1);
        }
        return result.trim();
    }

    private static Path location(Properties props) {
        String result = props.getProperty("jeka.distrib.location");
        if (result == null || result.trim().isEmpty()) {
            return null;
        }
        return Paths.get(result.trim(), new String[0]).resolve(BIN_NAME);
    }

    private static String repoOptions() {
        Properties properties = new Properties();
        Path globalPropertyFile = Booter.getJekaUserHomeDir().resolve("global.properties");
        if (!Files.exists(globalPropertyFile, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(globalPropertyFile, new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String url = properties.getProperty("repo.download.url");
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        return url.trim().endsWith("/") ? url.trim() : url.trim() + "/";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties props(Path jekawDir) {
        Path propFile = Booter.getWrapperPropsFile(jekawDir);
        if (!Files.exists(propFile, new LinkOption[0])) {
            System.out.println("No file found at " + propFile + ". Please re-run 'jeka scaffold#wrapper");
            System.exit(1);
        }
        Properties props = new Properties();
        try (InputStream inputStream = Files.newInputStream(propFile, new OpenOption[0]);){
            props.load(inputStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Properties props(String[] args) {
        Properties props = new Properties();
        Arrays.stream(args).filter(arg -> arg.startsWith("-D")).map(arg -> arg.substring(2)).filter(arg -> arg.contains("=")).map(arg -> arg.split("=")).forEach(items -> props.put(items[0], items[1]));
        return props;
    }

    private static InputStream openStream(String downloadUrl) throws IOException {
        URL url = new URL(downloadUrl);
        URLConnection uc = url.openConnection();
        String authorizationHeader = Booter.authorisationHeader(downloadUrl);
        if (authorizationHeader != null) {
            uc.setRequestProperty("Authorization", authorizationHeader);
        }
        return uc.getInputStream();
    }

    private static String authorisationHeader(String url) {
        if (url.startsWith(MAVEN_CENTRAL_URL)) {
            return null;
        }
        String username = System.getenv("JEKA_WRAPPER_REPO_USERNAME");
        String pwd = System.getenv("JEKA_WRAPPER_REPO_PWD");
        if (username == null || pwd == null || username.equals("") || pwd.equals("")) {
            return null;
        }
        String concat = username + ":" + pwd;
        String encoded = Base64.getEncoder().encodeToString(concat.getBytes(StandardCharsets.UTF_8));
        return "Basic " + encoded;
    }
}

