/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.repos;

import dev.jeka.core.api.depmanagement.JkRepo;
import dev.jeka.core.api.depmanagement.publication.JkNexusRepos;
import dev.jeka.core.api.function.JkConsumers;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import java.util.Optional;
import java.util.function.Consumer;

@JkDoc(value={"Provides features to release Nexus repos (as OSSRH) after publication."})
public class NexusJkBean
extends JkBean {
    private static final String TASK_NAME = "Closing and releasing repositories";
    @JkDoc(value={"Comma separated filters for taking in account only specified repositories with specified profile name."})
    public String profileNamesFilter = "";
    private final JkConsumers<JkNexusRepos, Void> nexusReposConfigurators = JkConsumers.of();

    protected NexusJkBean() {
        ProjectJkBean projectBean = this.getRuntime().getBeanOptional(ProjectJkBean.class).orElse(null);
        if (projectBean == null) {
            JkLog.warn("No project KBean present to configure repos for.", new Object[0]);
        } else {
            JkProject project = projectBean.getProject();
            projectBean.configure(this::configureProject);
        }
    }

    @JkDoc(value={"Closes and releases the configured nexus repositories."})
    public void closeAndOrRelease() {
        JkNexusRepos nexusRepos = this.getJkNexusRepos();
        if (nexusRepos == null) {
            return;
        }
        nexusRepos.closeAndRelease(this.profiles());
    }

    public NexusJkBean configure(Consumer<JkNexusRepos> nexusReposConsumer) {
        this.nexusReposConfigurators.append(nexusReposConsumer);
        return this;
    }

    private void configureProject(JkProject project) {
        JkNexusRepos nexusRepos = this.getJkNexusRepos();
        if (nexusRepos == null) {
            return;
        }
        project.getPublication().getPostActions().append(TASK_NAME, () -> nexusRepos.closeAndReleaseOpenRepositories(this.profiles()));
    }

    private String[] profiles() {
        return JkUtilsString.isBlank(this.profileNamesFilter) ? new String[]{} : this.profileNamesFilter.split(",");
    }

    private JkNexusRepos getJkNexusRepos() {
        Optional<ProjectJkBean> projectBean = this.getRuntime().getBeanOptional(ProjectJkBean.class);
        if (!projectBean.isPresent()) {
            JkLog.warn("No project plugin configured here.", new Object[0]);
            return null;
        }
        JkProject project = projectBean.get().getProject();
        JkRepo repo = project.getPublication().findFirstNonLocalRepo();
        if (repo == null) {
            JkLog.warn("No remote repository configured for publishing", new Object[0]);
            return null;
        }
        if (repo.getCredentials() == null || repo.getCredentials().isEmpty()) {
            JkLog.warn("No credentials found on repo " + repo, new Object[0]);
        }
        JkNexusRepos result = JkNexusRepos.ofUrlAndCredentials(repo);
        this.nexusReposConfigurators.accept(result);
        return result;
    }
}

