/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.maven;

import dev.jeka.core.api.depmanagement.JkDependencySet;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkProcess;
import dev.jeka.core.api.tooling.JkMvn;
import dev.jeka.core.api.tooling.JkPom;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@JkDoc(value={"Provides method to help migration from Maven."})
public class MavenJkBean
extends JkBean {
    @JkDoc(value={"Margin to print dependency code."})
    public int margin = 4;

    @JkDoc(value={"Displays Java code for declaring dependencies based on pom.xml. The pom.xml file is supposed to be in root directory."})
    public void migrationCode() {
        if (!Files.exists(this.getBaseDir().resolve("pom.xml"), new LinkOption[0])) {
            throw new IllegalStateException("No pom.xml file found at " + JkUtilsPath.friendlyName(this.getBaseDir()) + ". Won't process.");
        }
        Path effectivePom = JkUtilsPath.createTempFile("jeka-effective-pom-", ".pom", new FileAttribute[0]);
        ((JkProcess)((JkProcess)JkMvn.of(this.getBaseDir(), "help:effective-pom", "-Doutput=" + effectivePom.toString()).toProcess().setLogCommand(true)).setLogOutput(JkLog.isVerbose())).run();
        JkPom pom = JkPom.of(effectivePom);
        System.out.println("Compile");
        System.out.println(JkDependencySet.toJavaCode(this.margin, pom.getDependencies().getDependenciesHavingQualifier(null, "compile", "provided"), true));
        System.out.println("Runtime");
        System.out.print(JkDependencySet.toJavaCode(this.margin, pom.getDependencies().getDependenciesHavingQualifier("runtime"), true));
        System.out.println(JkDependencySet.toJavaCode(this.margin, pom.getDependencies().getDependenciesHavingQualifier("provided"), false));
        System.out.println("Test");
        System.out.println(JkDependencySet.toJavaCode(this.margin, pom.getDependencies().getDependenciesHavingQualifier("test"), true));
    }
}

