/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.ide;

import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsThrowable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class IntellijModulesXmlGenerator {
    private static final String ENCODING = "UTF-8";
    private static final String T1 = "  ";
    private static final String T2 = "    ";
    private static final String T3 = "      ";
    private final Iterable<Path> imlFiles;
    private final Path projectDir;
    private final Path outputFile;

    public IntellijModulesXmlGenerator(Path projectDir, Iterable<Path> imlFiles) {
        this.imlFiles = imlFiles;
        this.projectDir = projectDir;
        this.outputFile = projectDir.resolve(".idea/modules.xml");
    }

    public void generate() {
        try {
            this._generate();
        }
        catch (Exception e) {
            throw JkUtilsThrowable.unchecked(e);
        }
    }

    public Path outputFile() {
        return this.outputFile;
    }

    private void _generate() throws IOException, XMLStreamException, FactoryConfigurationError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos, ENCODING);
        writer.writeStartDocument(ENCODING, "1.0");
        writer.writeCharacters("\n");
        writer.writeStartElement("project");
        writer.writeCharacters("\n  ");
        writer.writeStartElement("component");
        writer.writeAttribute("name", "ProjectModuleManager");
        writer.writeCharacters("\n    ");
        writer.writeStartElement("modules");
        writer.writeCharacters("\n");
        for (Path iml : this.imlFiles) {
            Path relPath = this.projectDir.relativize(iml);
            JkLog.info("Iml file detected : " + relPath, new Object[0]);
            String path = this.path(relPath);
            writer.writeCharacters(T3);
            writer.writeEmptyElement("module");
            writer.writeAttribute("fileurl", "file://" + path);
            writer.writeAttribute("filepath", path);
            writer.writeCharacters("\n");
        }
        writer.writeCharacters(T2);
        writer.writeEndElement();
        writer.writeCharacters("\n  ");
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
        JkUtilsPath.deleteIfExists(this.outputFile);
        JkUtilsPath.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
        Files.write(this.outputFile, baos.toByteArray(), new OpenOption[0]);
    }

    private String path(Path relPath) {
        return "$PROJECT_DIR$/" + relPath.toString().replace('\\', '/');
    }
}

