/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool.builtins.git;

import dev.jeka.core.api.depmanagement.JkVersion;
import dev.jeka.core.api.project.JkProject;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.system.JkPrompt;
import dev.jeka.core.api.tooling.JkGitProcess;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.builtins.project.ProjectJkBean;
import java.util.Optional;

@JkDoc(value={"Provides common Git scripts/commands out of the box."})
public class GitJkBean
extends JkBean {
    @JkDoc(value={"Manages versioning of projects by extracting Git information.", "The version is inferred from git : ", "  - If git workspace is dirty (different than last commit), version values [branch]-SNAPSHOT", "  - If last commit contains a message containing [comment_version_prefix]xxxxx, version values xxxxx", "  - If last commit is tagged, version values [last tag on last commit]", "The inferred version is applied to project.publication.maven.version and project.publication.ivy.publication.", "After, if last commit message specifies a version and this version differs from tag, last commit is tagged with specified version."})
    public final ProjectVersionProvider projectVersionSupplier = new ProjectVersionProvider();
    private final JkGitProcess git = JkGitProcess.of(this.getBaseDir());

    protected GitJkBean() {
        if (this.projectVersionSupplier.on) {
            ProjectJkBean projectPlugin = this.getRuntime().getBeanOptional(ProjectJkBean.class).orElse(null);
            if (projectPlugin == null) {
                return;
            }
            projectPlugin.configure(project -> this.projectVersionSupplier.configure((JkProject)project, this.projectVersionSupplier.tagAfterPublish));
        }
    }

    @JkDoc(value={"Perform a dirty check first then put a tag at the HEAD and push it to remote."})
    public void tagRemote() {
        JkGitProcess aGit = (JkGitProcess)((JkGitProcess)this.git.copy().setLogCommand(false)).setLogOutput(false);
        System.out.println("Existing tags on origin :");
        ((JkGitProcess)aGit.copy().setLogOutput(true)).exec("ls-remote", "--tag", "--sort=creatordate", "origin");
        if (aGit.isWorkspaceDirty()) {
            System.out.println("Git workspace is dirty. Please clean your Git workspace and retry");
            return;
        }
        if (!aGit.isRemoteEqual()) {
            System.out.println("The current tracking branch is not aligned with the remote. Please update/push and retry.");
            return;
        }
        System.out.println("You are about to tag commit : " + this.git.getCurrentCommit());
        String newTag = JkPrompt.ask("Enter new tag : ");
        ((JkGitProcess)aGit.setLogCommand(true)).tagAndPush(newTag);
    }

    @JkDoc(value={"Display version supplied to the project."})
    public void showVersion() {
        if (!this.projectVersionSupplier.on) {
            JkLog.warn("The project is not configured to get its version from Git. Use git#projectVersionSupplier.on=true", new Object[0]);
        } else {
            JkLog.info(this.projectVersionSupplier.version().toString(), new Object[0]);
        }
    }

    public JkGitProcess getGitProcess() {
        return this.git;
    }

    public class ProjectVersionProvider {
        @JkDoc(value={"If true and a ProjectJkBean project is bound to the build instance, the project will be configured for publishing with the inferred version."})
        public boolean on = false;
        public static final String TAG_TASK_NAME = "version-from-git-tag";
        @JkDoc(value={"The prefix to use in commit message to specify a version."})
        public String commentVersionPrefix = "Release:";
        @JkDoc(value={"Tags with following prefix. This may help to distinguish tags for versioning from others."})
        public String tagPrefixForVersion = "";
        @JkDoc(value={"If true and autoConfigureProject, project will be configured to push tag after project.publication.publish() succeed."})
        public boolean tagAfterPublish = true;
        private transient JkVersion cachedVersion;

        public boolean tagIfDiffers() {
            String commitCommentVersion = GitJkBean.this.git.extractSuffixFromLastCommitMessage(this.commentVersionPrefix);
            if (commitCommentVersion == null) {
                return false;
            }
            String currentTagVersion = GitJkBean.this.git.getVersionFromTag(this.tagPrefixForVersion);
            if (!commitCommentVersion.equals(currentTagVersion)) {
                JkLog.info("Tagging git with " + commitCommentVersion, new Object[0]);
                GitJkBean.this.git.tagAndPush(this.tagPrefixForVersion + commitCommentVersion);
                return true;
            }
            return false;
        }

        public JkVersion version() {
            if (this.cachedVersion != null) {
                return this.cachedVersion;
            }
            boolean dirty = GitJkBean.this.git.isWorkspaceDirty();
            if (dirty) {
                this.cachedVersion = JkVersion.of(GitJkBean.this.git.getCurrentBranch()).toSnapshot();
            } else {
                String commitCommentVersion = GitJkBean.this.git.extractSuffixFromLastCommitMessage(this.commentVersionPrefix);
                this.cachedVersion = JkVersion.of(Optional.ofNullable(commitCommentVersion).orElseGet(() -> GitJkBean.this.git.getVersionFromTag(this.tagPrefixForVersion)));
            }
            JkLog.info("Version inferred from Git:" + this.cachedVersion, new Object[0]);
            return this.cachedVersion;
        }

        public void configure(JkProject project, boolean tag) {
            project.getPublication().setVersion(() -> this.version().toString());
            if (tag) {
                project.getPublication().getPostActions().append(TAG_TASK_NAME, this::tagIfDiffers);
            }
        }

        public String versionAsText() {
            return this.version().getValue();
        }

        public void refresh() {
            this.cachedVersion = null;
        }
    }
}

