/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.system.JkLocator;
import dev.jeka.core.api.utils.JkUtilsFile;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.Environment;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

final class PropertyLoader {
    private PropertyLoader() {
    }

    static void load() {
        TreeMap<String, String> props = new TreeMap<String, String>();
        props.putAll(PropertyLoader.readGlobalProperties());
        props.putAll(PropertyLoader.readProjectPropertiesRecursively(Paths.get("", new String[0])));
        props.putAll(Environment.commandLine.getSystemProperties());
        props.forEach((k, v) -> System.setProperty(k, v));
    }

    static Map<String, String> toDisplayedMap(Map<String, String> props) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String value = JkUtilsString.firstMatching(entry.getKey().toLowerCase(), "password", "pwd") != null && entry.getValue() != null ? "*****" : entry.getValue();
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private static Map<String, String> readGlobalProperties() {
        Path userPropFile = JkLocator.getJekaUserHomeDir().resolve("global.properties");
        if (Files.exists(userPropFile, new LinkOption[0])) {
            return JkUtilsFile.readPropertyFileAsMap(userPropFile);
        }
        return Collections.emptyMap();
    }

    static Map<String, String> readProjectPropertiesRecursively(Path projectBaseDir) {
        Path presetCommandsFile;
        Path parentProject = projectBaseDir.toAbsolutePath().normalize().getParent();
        HashMap<String, String> result = new HashMap<String, String>();
        if (parentProject != null && Files.exists(parentProject.resolve("jeka"), new LinkOption[0]) & Files.isDirectory(parentProject.resolve("jeka"), new LinkOption[0])) {
            result.putAll(PropertyLoader.readProjectPropertiesRecursively(parentProject));
        }
        if (Files.exists(presetCommandsFile = projectBaseDir.resolve("jeka").resolve("project.properties"), new LinkOption[0])) {
            result.putAll(JkUtilsFile.readPropertyFileAsMap(presetCommandsFile));
        }
        return result;
    }
}

