/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.depmanagement.JkRepoFromProperties;
import dev.jeka.core.api.depmanagement.JkRepoSet;
import dev.jeka.core.api.system.JkProperties;
import dev.jeka.core.api.tooling.intellij.JkImlGenerator;
import dev.jeka.core.tool.EngineBeanClassResolver;
import dev.jeka.core.tool.Environment;
import dev.jeka.core.tool.JkBean;
import dev.jeka.core.tool.PropertyLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public final class JkExternalToolApi {
    private JkExternalToolApi() {
    }

    public static String getBeanName(String fullyQualifiedClassName) {
        return JkBean.name(fullyQualifiedClassName);
    }

    public static List<String> getCachedBeanClassNames(Path projectRoot) {
        return new EngineBeanClassResolver(projectRoot).readKbeanClasses();
    }

    public static JkRepoSet getDownloadRepos(Path projectDir) {
        Map<String, String> projectProps = PropertyLoader.readProjectPropertiesRecursively(projectDir);
        JkProperties.override(projectProps);
        JkRepoSet result = JkRepoFromProperties.getDownloadRepos();
        JkProperties.removeOverride();
        return result;
    }

    public static boolean isJekaProject(Path candidate) {
        Path jekaDir = candidate.resolve("jeka");
        if (!Files.isDirectory(jekaDir, new LinkOption[0])) {
            return false;
        }
        Path defDir = jekaDir.resolve("jeka/def");
        if (Files.isDirectory(defDir, new LinkOption[0])) {
            return true;
        }
        if (Files.isRegularFile(jekaDir.resolve("project.properties"), new LinkOption[0])) {
            return true;
        }
        if (Files.isRegularFile(jekaDir.resolve("cmd.properties"), new LinkOption[0])) {
            return true;
        }
        if (Files.isRegularFile(jekaDir.resolve("dependencies.txt"), new LinkOption[0])) {
            return true;
        }
        Path wrapperDir = jekaDir.resolve("wrapper");
        if (Files.isDirectory(wrapperDir, new LinkOption[0])) {
            return true;
        }
        if (Files.isRegularFile(candidate.resolve("jekaw"), new LinkOption[0])) {
            return true;
        }
        return Files.isRegularFile(candidate.resolve("jekaw.bat"), new LinkOption[0]);
    }

    public static Path getImlFile(Path moduleDir) {
        return JkImlGenerator.getImlFilePath(moduleDir);
    }

    public static Map<String, String> getCmdPropertiesContent(Path projectDir) {
        return Environment.projectCmdProperties(projectDir);
    }
}

