/*
 * Decompiled with CFR 0.152.
 */
package dev.jeka.core.tool;

import dev.jeka.core.api.file.JkPathTree;
import dev.jeka.core.api.system.JkLog;
import dev.jeka.core.api.utils.JkUtilsPath;
import dev.jeka.core.api.utils.JkUtilsString;
import dev.jeka.core.tool.HelpDisplayer;
import dev.jeka.core.tool.JkDoc;
import dev.jeka.core.tool.JkImportedJkBeans;
import dev.jeka.core.tool.JkRuntime;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class JkBean {
    private static final String JKBEAN_CLASS_SIMPLE_NAME = JkBean.class.getSimpleName();
    private static final String CLASS_SUFFIX = JkBean.class.getSimpleName();
    private JkRuntime runtime;
    private final JkImportedJkBeans importedJkBeans;

    private JkBean(JkRuntime runtime) {
        this.runtime = runtime;
        this.importedJkBeans = new JkImportedJkBeans(this);
    }

    protected JkBean() {
        this(JkRuntime.getCurrentContextBaseDir());
    }

    @JkDoc(value={"Displays help about this KBean"})
    public void help() {
        HelpDisplayer.helpJkBean(this);
    }

    public Path getBaseDir() {
        return this.runtime.getProjectBaseDir();
    }

    public String getBaseDirName() {
        String result = this.getBaseDir().getFileName().toString();
        return result.isEmpty() ? this.getBaseDir().toAbsolutePath().getFileName().toString() : result;
    }

    public Path getOutputDir() {
        return this.getBaseDir().resolve("jeka/output");
    }

    final String shortName() {
        return JkBean.name(this.getClass());
    }

    @JkDoc(value={"Delete content of jeka/output directory"})
    public void clean() {
        Path output = this.getOutputDir();
        JkLog.info("Clean output directory " + output, new Object[0]);
        if (Files.exists(output, new LinkOption[0])) {
            JkPathTree.of(output).deleteContent();
        }
    }

    public JkImportedJkBeans getImportedJkBeans() {
        return this.importedJkBeans;
    }

    public JkRuntime getRuntime() {
        return this.runtime;
    }

    public <T extends JkBean> T getBean(Class<T> beanClass) {
        return this.runtime.getBean(beanClass);
    }

    static String name(String fullyQualifiedClassName) {
        String className;
        String string = className = fullyQualifiedClassName.contains(".") ? JkUtilsString.substringAfterLast(fullyQualifiedClassName, ".") : fullyQualifiedClassName;
        if (!className.endsWith(CLASS_SUFFIX) || className.equals(CLASS_SUFFIX)) {
            return JkUtilsString.uncapitalize(className);
        }
        String prefix = JkUtilsString.substringBeforeLast(className, CLASS_SUFFIX);
        return JkUtilsString.uncapitalize(prefix);
    }

    static String name(Class<?> jkBeanClass) {
        return JkBean.name(jkBeanClass.getName());
    }

    static boolean nameMatches(String className, String nameCandidate) {
        if (nameCandidate.equals(className)) {
            return true;
        }
        String classSimpleName = className.contains(".") ? JkUtilsString.substringAfterLast(className, ".") : className;
        String uncapitalizedClassSimpleName = JkUtilsString.uncapitalize(classSimpleName);
        if (JkUtilsString.uncapitalize(nameCandidate).equals(uncapitalizedClassSimpleName)) {
            return true;
        }
        if (className.endsWith(JKBEAN_CLASS_SIMPLE_NAME)) {
            return uncapitalizedClassSimpleName.equals(nameCandidate + JkBean.class.getSimpleName());
        }
        return false;
    }

    public String toString() {
        return this.shortName() + " in project '" + JkUtilsPath.friendlyName(this.runtime.getProjectBaseDir()) + "'";
    }
}

